/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASDeploymentPlanDeployer
implements DeploymentPlanDeployer {
    private IDeployerManager deployerManager = null;
    private ServerProperties serverProperties = null;
    private Log logger = LogFactory.getLog(JOnASDeploymentPlanDeployer.class);
    private static final String JONAS_SERVICE = "jonas.service";
    private static final String DEPLOYMENT_CONFIG_DIR = JProp.getConfDir() + File.separator + "deployment";

    public void deploy(String name) throws Exception {
        File file;
        String service = name;
        File configDir = new File(DEPLOYMENT_CONFIG_DIR);
        final String baseName = name + "-base";
        File[] base = configDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(baseName.concat(".xml"));
            }
        });
        if (base.length == 1) {
            this.deploy(baseName);
            String serviceClass = this.serverProperties.getValue("jonas.service." + service + ".class");
            String implementationName = serviceClass.split("\\.")[4];
            service = service + "-" + implementationName;
        }
        if (!(file = new File(DEPLOYMENT_CONFIG_DIR, service + ".xml")).exists()) {
            throw new FileNotFoundException("Cannot deploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.deployDeploymentPlan(file);
    }

    public void undeploy(String name) throws Exception {
        File file = new File(DEPLOYMENT_CONFIG_DIR, name + ".xml");
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot undeploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.undeployDeploymentPlan(file);
    }

    private void deployDeploymentPlan(File file) throws Exception {
        this.logger.debug("Deploying the deployment plan for ''{0}''", file);
        IArchive archive = ArchiveManager.getInstance().getArchive(file);
        if (archive == null) {
            throw new Exception("Ignoring invalid file '" + file + "'");
        }
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(archive);
            this.deployerManager.deploy(deployable);
        }
        catch (Exception e) {
            throw new Exception("Cannot deploy the deployment plan for '" + file + "'", e);
        }
    }

    private void undeployDeploymentPlan(File file) throws Exception {
        this.logger.debug("Undeploying the deployment plan for ''{0}''", file);
        IArchive archive = ArchiveManager.getInstance().getArchive(file);
        if (archive == null) {
            throw new Exception("Ignoring invalid file '" + file + "'");
        }
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(archive);
            this.deployerManager.undeploy(deployable);
        }
        catch (Exception e) {
            throw new Exception("Cannot undeploy the deployment plan for '" + file + "'", e);
        }
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }
}

