/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.workmanager.internal;

import javax.management.ObjectName;
import javax.resource.spi.work.WorkManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.workmanager.WorkManagerService;
import org.ow2.jonas.workmanager.internal.JWorkManager;

public class JOnASWorkManagerService
extends AbsServiceImpl
implements WorkManagerService {
    private static Logger logger = Log.getLogger("org.ow2.jonas.lib.work");
    private static final int MIN_WORK_THREADS_DEFAULT = 3;
    private static final int MAX_WORK_THREADS_DEFAULT = 80;
    private static final int THREAD_WAIT_TIMEOUT_DEFAULT = 60;
    private JWorkManager workManager = null;
    private int minPoolSize = 3;
    private int maxPoolSize = 80;
    private long threadWaitingTime = 60L;
    private JmxService jmxService;
    private TransactionService transactionService;

    public void setThreadwaittimeout(long waitingTime) {
        this.threadWaitingTime = waitingTime;
    }

    public void setMinworkthreads(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxworkthreads(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    protected void doStart() throws ServiceException {
        this.workManager = new JWorkManager(this.minPoolSize, this.maxPoolSize, this.transactionService, this.threadWaitingTime);
        this.registerWorkManagerMBean(this.getDomainName(), this.workManager);
        logger.log(BasicLevel.INFO, (Object)"WorkManager Service started.");
    }

    protected void doStop() throws ServiceException {
        this.workManager.stopThreads();
        this.workManager = null;
        if (this.jmxService != null) {
            this.unregisterWorkManagerMBean(this.getDomainName());
        }
        logger.log(BasicLevel.INFO, (Object)"WorkManager Service stopped.");
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    private void registerWorkManagerMBean(String domainName, JWorkManager workManager) {
        ObjectName on = JonasObjectName.workManager(domainName);
        try {
            this.jmxService.registerModelMBean((Object)workManager, on);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register WorkManager MBean", (Throwable)e);
        }
    }

    private void unregisterWorkManagerMBean(String domainName) {
        ObjectName on = JonasObjectName.workManager(domainName);
        try {
            this.jmxService.unregisterModelMBean(on);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not unregister WorkManager MBean", (Throwable)e);
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

