/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.publish.internal.file;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.publish.PublicationInfo;
import org.ow2.jonas.ws.publish.WSDLPublisher;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.internal.file.JDefinitionWriter;

public class FileWSDLPublisher
implements WSDLPublisher {
    private File location;
    private Charset cs;
    private static final String OUTPUT_DIRECTORY = "jonas.service.publish.file.directory";
    private static final String ENCODING = "jonas.service.publish.file.encoding";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ws");

    public FileWSDLPublisher(Properties props) throws WSDLPublisherException {
        String directory = props.getProperty(OUTPUT_DIRECTORY);
        if (directory == null) {
            String jonasBase = JProp.getJonasBase();
            directory = new File(jonasBase, "wsdls").getPath();
        }
        String encoding = props.getProperty(ENCODING, "UTF-8");
        try {
            this.location = new File(directory).getCanonicalFile();
            if (!this.location.exists()) {
                this.location.mkdirs();
            }
            this.cs = Charset.forName(encoding);
        }
        catch (IOException ioe) {
            throw new WSDLPublisherException("cannot find/create the publishing directory '" + directory + "'", ioe);
        }
        catch (IllegalCharsetNameException icsne) {
            throw new WSDLPublisherException("Illegal Charset '" + encoding + "'", icsne);
        }
        catch (UnsupportedCharsetException ucse) {
            throw new WSDLPublisherException("Charset '" + encoding + "' not supported on this platform.", ucse);
        }
    }

    public void publish(Definition definition, PublicationInfo info) throws WSDLPublisherException {
        String fileName = info.getOriginalWsdlFilename();
        logger.log(BasicLevel.DEBUG, (Object)("Attempting to publish '" + fileName + "'"));
        File sLoc = null;
        File pubDirectory = info.getPublicationDirectory();
        sLoc = pubDirectory == null ? this.location : (pubDirectory.isAbsolute() ? pubDirectory : new File(this.location, pubDirectory.getPath()));
        try {
            sLoc = sLoc.getCanonicalFile();
            logger.log(BasicLevel.DEBUG, (Object)("Publishing into directory '" + sLoc + "'"));
            this.createDirIfNeeded(sLoc);
            JDefinitionWriter jdw = new JDefinitionWriter(definition, sLoc, this.cs, fileName);
            jdw.write();
        }
        catch (IOException ioe) {
            throw new WSDLPublisherException("Error with writer of file '" + fileName + "'", ioe);
        }
        catch (WSDLException we) {
            throw new WSDLPublisherException("Error with wsdl file '" + fileName + "' publishing in directory '" + this.location + "'", we);
        }
    }

    private void createDirIfNeeded(File file) throws IOException {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException("Cannot create directory " + file.getCanonicalPath());
            }
        } else if (!file.isDirectory()) {
            throw new IOException("Parent " + file.getCanonicalPath() + " already exists but is not a directory.");
        }
    }
}

