/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.builder.webserviceref;

import javax.naming.NamingException;
import javax.naming.Reference;
import org.ow2.util.ee.builder.webserviceref.ReferenceHelper;
import org.ow2.util.ee.builder.webserviceref.factory.WebServiceRefObjectFactory;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;

public class WebServiceRefBuilder {
    public Reference build(IJaxwsWebServiceRef serviceRef) throws NamingException {
        if (WebServiceRefBuilder.isNullOrEmpty(serviceRef.getValue())) {
            serviceRef.setValue(serviceRef.getType());
        }
        String referenceClassname = null;
        String serviceClassname = serviceRef.getValue();
        String seiClassname = null;
        if (!serviceRef.getValue().equals(serviceRef.getType())) {
            referenceClassname = serviceRef.getType();
            seiClassname = serviceRef.getType();
        } else {
            referenceClassname = serviceRef.getValue();
        }
        Reference ref = this.createReference(referenceClassname);
        ReferenceHelper helper = new ReferenceHelper(ref);
        helper.insert("service-class", serviceClassname);
        helper.insert("service-endpoint-interface", seiClassname);
        helper.insert("wsdl-location", serviceRef.getWsdlLocation());
        return ref;
    }

    protected Reference createReference(String classname) {
        return new Reference(classname, WebServiceRefObjectFactory.class.getName(), null);
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value);
    }
}

