/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.builder.webserviceref.factory;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.ow2.util.ee.builder.webserviceref.ReferenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Constructor<Service> constructor;
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        ReferenceHelper helper = new ReferenceHelper(ref);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String serviceClassname = helper.extract("service-class");
        String seiClassname = helper.extract("service-endpoint-interface");
        String wsdlLocation = helper.extract("wsdl-location");
        Class<Service> serviceClass = null;
        serviceClass = Class.forName(serviceClassname, true, loader).asSubclass(Service.class);
        boolean haveWSDL = true;
        URL location = null;
        if (wsdlLocation != null) {
            try {
                location = new URL(wsdlLocation);
            }
            catch (MalformedURLException mue) {
                ClassLoader serviceLoader = serviceClass.getClassLoader();
                location = serviceLoader.getResource(wsdlLocation);
                if (location == null) {
                    location = loader.getResource(wsdlLocation);
                }
                if (location == null) {
                    haveWSDL = false;
                }
            }
        } else {
            haveWSDL = false;
        }
        QName serviceQName = null;
        WebServiceClient annotation = serviceClass.getAnnotation(WebServiceClient.class);
        if (annotation != null) {
            serviceQName = new QName(annotation.targetNamespace(), annotation.name());
        }
        Service service = null;
        if (haveWSDL) {
            constructor = serviceClass.getConstructor(URL.class, QName.class);
            service = constructor.newInstance(location, serviceQName);
        } else {
            constructor = serviceClass.getConstructor(new Class[0]);
            service = constructor.newInstance(new Object[0]);
        }
        this.processObjectInstance(service, ref);
        Service returnedObject = service;
        if (seiClassname != null) {
            ClassLoader serviceClassLoader = service.getClass().getClassLoader();
            Class<?> sei = serviceClassLoader.loadClass(seiClassname);
            returnedObject = service.getPort(sei);
        }
        return returnedObject;
    }

    protected void processObjectInstance(Service service, Reference ref) throws Exception {
    }
}

