/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.merge;

import java.util.List;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.impl.xml.merge.MetadataMerge;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WarMetadataMerge
extends MetadataMerge {
    private static final Log LOGGER = LogFactory.getLog(WarMetadataMerge.class);
    private WarDeployableMetadata warDeployableMetadata;

    public WarMetadataMerge(WarDeployableMetadata warDeployableMetadata) {
        this.warDeployableMetadata = warDeployableMetadata;
    }

    public void merge(WAR war) {
        this.applyJndiEnvironmentRefsGroup(war, this.warDeployableMetadata);
        for (IWarClassMetadata warClassmetadata : this.warDeployableMetadata.getWarClassMetadataCollection()) {
            List<IJAnnotationResource> annotationResourcesDeployable;
            List<IJavaxPersistenceUnit> persistenceUnitsDeployable = this.warDeployableMetadata.getJavaxPersistencePersistenceUnits();
            if (persistenceUnitsDeployable != null && persistenceUnitsDeployable.size() > 0) {
                List<IJavaxPersistenceUnit> persistenceUnitsClass = warClassmetadata.getJavaxPersistencePersistenceUnits();
                if (persistenceUnitsClass == null) {
                    warClassmetadata.setJavaxPersistencePersistenceUnits(persistenceUnitsDeployable);
                } else {
                    persistenceUnitsClass.addAll(persistenceUnitsDeployable);
                }
            }
            if ((annotationResourcesDeployable = this.warDeployableMetadata.getJAnnotationResources()) == null || annotationResourcesDeployable.size() <= 0) continue;
            List<IJAnnotationResource> annotationResourcesClass = warClassmetadata.getJAnnotationResources();
            if (annotationResourcesClass == null) {
                warClassmetadata.setJAnnotationResources(annotationResourcesDeployable);
                continue;
            }
            annotationResourcesClass.addAll(annotationResourcesDeployable);
        }
    }

    public IWarClassMetadata getClassMetadata(String className) {
        return this.warDeployableMetadata.getWarClassMetadata(className);
    }

    public String findDefaultClassForEnvironment(IEnvironmentRefAccessor env) {
        return null;
    }
}

