/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.ha.local;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.local.LocalConnection;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdListNot;
import org.objectweb.joram.mom.proxies.ResetCollocatedConnectionsNot;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class HALocalConnection
implements RequestChannel {
    public static final int NONE = 0;
    public static final int INIT = 1;
    public static final int RUN = 2;
    private static Object lock = new Object();
    private static int status;
    private String userName;
    private String password;
    private LocalConnection localConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String args, boolean firstTime) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("HALocalConnection.init(" + args + ',' + firstTime + ')'));
        }
        Object object = lock;
        synchronized (object) {
            status = 1;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForStart() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"HALocalConnection.waitForStart()");
        }
        Object object = lock;
        synchronized (object) {
            while (status == 0) {
                try {
                    lock.wait();
                }
                catch (InterruptedException exc) {}
            }
            if (status == 1) {
                GetProxyIdListNot gpin = new GetProxyIdListNot();
                try {
                    gpin.invoke(AdminTopic.getDefault());
                    AgentId[] proxyIds = gpin.getIds();
                    ResetCollocatedConnectionsNot rccn = new ResetCollocatedConnectionsNot();
                    for (int i = 0; i < proxyIds.length; ++i) {
                        Channel.sendTo(proxyIds[i], rccn);
                    }
                    status = 2;
                }
                catch (Exception exc) {
                    JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                    throw new Error(exc.toString());
                }
            }
        }
    }

    public HALocalConnection(String userName2, String password2) throws JMSException {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("HALocalConnection.<init>(" + this.userName + ',' + this.password + ')'));
        }
        HALocalConnection.waitForStart();
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)" -> create the local connection");
        }
        this.userName = userName2;
        this.password = password2;
    }

    public void setTimer(Timer timer) {
    }

    public void connect() throws Exception {
        this.localConnection = new LocalConnection(this.userName, this.password);
        this.localConnection.connect();
    }

    public void send(AbstractJmsRequest request) throws Exception {
        this.localConnection.send(request);
    }

    public AbstractJmsReply receive() throws Exception {
        return this.localConnection.receive();
    }

    public void close() {
        this.localConnection.close();
    }
}

