/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.util.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.openmbean.TabularData;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.messages.Message;
import org.objectweb.joram.mom.proxies.ClientSubscriptionMBean;
import org.objectweb.joram.mom.proxies.MessageJMXWrapper;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

class ClientSubscription
implements ClientSubscriptionMBean,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(ClientSubscription.class.getName());
    private AgentId proxyId;
    private boolean durable;
    private AgentId topicId;
    private String name;
    private String selector;
    private AgentId dmqId;
    private Integer threshold;
    protected int nbMaxMsg = -1;
    private Vector messageIds;
    private Hashtable deliveredIds;
    private Hashtable deniedMsgs;
    private transient int contextId;
    private transient int subRequestId;
    private transient boolean noLocal;
    private transient boolean noFiltering;
    private transient boolean active;
    private transient int requestId;
    private transient boolean toListener;
    private transient long requestExpTime;
    private transient Hashtable messagesTable;
    private transient ProxyAgentItf proxy;
    protected long nbMsgsSentToDMQSinceCreation = 0L;
    protected long nbMsgsDeliveredSinceCreation = 0L;

    ClientSubscription(AgentId proxyId, int contextId, int reqId, boolean durable, AgentId topicId, String name, String selector, boolean noLocal, AgentId dmqId, Integer threshold, Hashtable messagesTable) {
        this.proxyId = proxyId;
        this.contextId = contextId;
        this.subRequestId = reqId;
        this.durable = durable;
        this.topicId = topicId;
        this.name = name;
        this.selector = selector;
        this.noLocal = noLocal;
        this.dmqId = dmqId;
        this.threshold = threshold;
        this.messagesTable = messagesTable;
        this.messageIds = new Vector();
        this.deliveredIds = new Hashtable();
        this.deniedMsgs = new Hashtable();
        this.noFiltering = !noLocal && (selector == null || selector.equals(""));
        this.active = true;
        this.requestId = -1;
        this.toListener = false;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public String toString() {
        return "ClientSubscription" + this.proxyId + this.name;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getSubRequestId() {
        return this.subRequestId;
    }

    public String getName() {
        return this.name;
    }

    public AgentId getTopicId() {
        return this.topicId;
    }

    public String getTopicIdAsString() {
        return this.topicId.toString();
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean getDurable() {
        return this.durable;
    }

    public boolean getActive() {
        return this.active;
    }

    public int getNbMaxMsg() {
        return this.nbMaxMsg;
    }

    public void setNbMaxMsg(int nbMaxMsg) {
        this.nbMaxMsg = nbMaxMsg;
    }

    public int getPendingMessageCount() {
        return this.messageIds.size();
    }

    public String[] getMessageIds() {
        Object[] res = new String[this.messageIds.size()];
        this.messageIds.copyInto(res);
        return res;
    }

    void setProxyAgent(ProxyAgentItf px) {
        this.proxy = px;
    }

    void reinitialize(Hashtable messagesTable, Vector persistedMessages, boolean denyDeliveredMessages) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this + "].reinitialize()"));
        }
        this.messagesTable = messagesTable;
        Enumeration e = persistedMessages.elements();
        while (e.hasMoreElements()) {
            Message message = (Message)e.nextElement();
            String msgId = message.getIdentifier();
            if (!this.messageIds.contains(msgId) && !this.deliveredIds.contains(msgId)) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> contains message " + msgId));
            }
            ++message.acksCounter;
            ++message.durableAcksCounter;
            if (message.acksCounter != 1) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> messagesTable.put(" + msgId + ')'));
            }
            messagesTable.put(msgId, message);
        }
        if (denyDeliveredMessages) {
            this.deny(this.deliveredIds.keys());
            this.deliveredIds.clear();
        }
    }

    void reactivate(int contextId, int reqId, AgentId topicId, String selector, boolean noLocal) {
        this.contextId = contextId;
        this.subRequestId = reqId;
        this.topicId = topicId;
        this.selector = selector;
        this.noLocal = noLocal;
        this.noFiltering = !noLocal && (selector == null || selector.equals(""));
        this.active = true;
        this.requestId = -1;
        this.toListener = false;
        this.save();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": reactivated."));
        }
    }

    void deactivate() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ClientSubscription.deactivate()");
        }
        this.unsetListener();
        this.unsetReceiver();
        this.active = false;
        this.deny(this.deliveredIds.keys());
        this.deliveredIds.clear();
        this.save();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": deactivated."));
        }
    }

    void setActive(boolean active) {
        this.active = active;
    }

    void setListener(int requestId) {
        this.requestId = requestId;
        this.toListener = true;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": listener set."));
        }
    }

    void unsetListener() {
        this.requestId = -1;
        this.toListener = false;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": listener unset."));
        }
    }

    void setReceiver(int requestId, long timeToLive) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".setReceiver(" + requestId + "," + timeToLive + ")"));
        }
        this.requestId = requestId;
        this.toListener = false;
        this.requestExpTime = timeToLive > 0L ? System.currentTimeMillis() + timeToLive : 0L;
    }

    void unsetReceiver() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".unsetReceiver()"));
        }
        this.requestId = -1;
        this.requestExpTime = 0L;
    }

    void setDMQId(AgentId dmqId) {
        this.dmqId = dmqId;
        this.save();
    }

    void setThreshold(Integer threshold) {
        this.threshold = threshold;
        this.save();
    }

    void browseNewMessages(Vector newMessages) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".browseNewMessages(" + newMessages + ')'));
        }
        DMQManager dmqManager = null;
        Enumeration e = newMessages.elements();
        while (e.hasMoreElements()) {
            Message message = (Message)e.nextElement();
            String msgId = message.getIdentifier();
            if (this.nbMaxMsg > -1 && this.nbMaxMsg <= this.messageIds.size()) {
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, null);
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)5);
                continue;
            }
            if (!this.noFiltering && (!Selector.matches(message.getHeaderMessage(), this.selector) || this.noLocal && msgId.startsWith(this.proxyId.toString().substring(1) + "c" + this.contextId + "m", 3))) continue;
            if (message.acksCounter == 0) {
                this.messagesTable.put(msgId, message);
            }
            ++message.acksCounter;
            if (this.durable) {
                ++message.durableAcksCounter;
            }
            this.messageIds.add(msgId);
            this.save();
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)(this + ": added msg " + msgId + " for delivery."));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    ConsumerMessages deliver() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this.proxyId + ',' + this.topicId + ',' + this.name + "].deliver()"));
        }
        if (this.requestId == -1) {
            return null;
        }
        if (!this.toListener && this.requestExpTime > 0L && System.currentTimeMillis() >= this.requestExpTime) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)(this + ": receive request " + this.requestId + " expired."));
            }
            this.requestId = -1;
            this.requestExpTime = 0L;
            return null;
        }
        Integer deliveryAttempts = null;
        int lastPrior = -1;
        int insertionIndex = -1;
        Vector<Object> deliverables = new Vector<Object>();
        DMQManager dmqManager = null;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> messageIds.size() = " + this.messageIds.size()));
        }
        if (this.toListener) {
            while (!this.messageIds.isEmpty()) {
                String id = (String)this.messageIds.remove(0);
                this.save();
                Message message = (Message)this.messagesTable.get(id);
                if (message != null) {
                    if (message.isValid(System.currentTimeMillis())) {
                        this.deliveredIds.put(id, id);
                        deliveryAttempts = (Integer)this.deniedMsgs.get(id);
                        if (deliveryAttempts == null) {
                            message.setDeliveryCount(1);
                        } else {
                            message.setDeliveryCount(deliveryAttempts + 1);
                            message.setRedelivered();
                        }
                        if (lastPrior == -1 || message.getPriority() == lastPrior) {
                            ++insertionIndex;
                        } else {
                            int prior;
                            for (insertionIndex = 0; insertionIndex < deliverables.size() && (prior = ((Message)deliverables.get(insertionIndex)).getPriority()) >= message.getPriority(); ++insertionIndex) {
                            }
                        }
                        lastPrior = message.getPriority();
                        deliverables.add(insertionIndex, message.getFullMessage().clone());
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)(this + ": message " + id + " added for delivery."));
                        continue;
                    }
                    this.messagesTable.remove(id);
                    if (this.durable) {
                        message.delete();
                    }
                    if ((deliveryAttempts = (Integer)this.deniedMsgs.remove(id)) != null) {
                        message.setDeliveryCount(deliveryAttempts + 1);
                        message.setRedelivered();
                    }
                    if (dmqManager == null) {
                        dmqManager = new DMQManager(this.dmqId, null);
                    }
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
                    continue;
                }
                this.deniedMsgs.remove(id);
            }
        } else {
            int highestP = -1;
            Message keptMsg = null;
            int i = 0;
            while (i < this.messageIds.size()) {
                String id = (String)this.messageIds.elementAt(i);
                Message message = (Message)this.messagesTable.get(id);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> message = " + message));
                }
                if (message != null) {
                    if (message.isValid(System.currentTimeMillis())) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)" -> valid message");
                        }
                        if (message.getPriority() > highestP) {
                            highestP = message.getPriority();
                            keptMsg = message;
                        }
                        ++i;
                        continue;
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)" -> invalid message");
                    }
                    this.messageIds.remove(id);
                    this.save();
                    this.messagesTable.remove(id);
                    if (this.durable) {
                        message.delete();
                    }
                    if ((deliveryAttempts = (Integer)this.deniedMsgs.remove(id)) != null) {
                        message.setDeliveryCount(deliveryAttempts);
                        message.setRedelivered();
                    }
                    if (dmqManager == null) {
                        dmqManager = new DMQManager(this.dmqId, null);
                    }
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
                    continue;
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> deleted message");
                }
                this.messageIds.remove(id);
                this.deniedMsgs.remove(id);
                this.save();
            }
            if (keptMsg != null) {
                this.messageIds.remove(keptMsg.getIdentifier());
                this.deliveredIds.put(keptMsg.getIdentifier(), keptMsg.getIdentifier());
                this.save();
                deliveryAttempts = (Integer)this.deniedMsgs.get(keptMsg.getIdentifier());
                if (deliveryAttempts == null) {
                    keptMsg.setDeliveryCount(1);
                } else {
                    keptMsg.setDeliveryCount(deliveryAttempts + 1);
                    keptMsg.setRedelivered();
                }
                deliverables.add(keptMsg.getFullMessage().clone());
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(this + ": message " + keptMsg.getIdentifier() + " added for delivery."));
                }
            } else {
                ++i;
            }
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (!deliverables.isEmpty()) {
            this.nbMsgsDeliveredSinceCreation += (long)deliverables.size();
            ConsumerMessages consM = new ConsumerMessages(this.requestId, deliverables, this.name, false);
            if (!this.toListener) {
                this.requestId = -1;
            }
            return consM;
        }
        return null;
    }

    void acknowledge(Enumeration acks) {
        while (acks.hasMoreElements()) {
            String id = (String)acks.nextElement();
            this.acknowledge(id);
        }
    }

    void acknowledge(String id) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": acknowledges message: " + id));
        }
        this.deliveredIds.remove(id);
        this.deniedMsgs.remove(id);
        this.save();
        Message msg = (Message)this.messagesTable.get(id);
        if (msg != null) {
            this.decrAckCounters(id, msg);
        }
    }

    void deny(Enumeration denies) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".deny(" + denies + ')'));
        }
        int deliveryAttempts = 1;
        DMQManager dmqManager = null;
        while (denies.hasMoreElements()) {
            Message message;
            String id = (String)denies.nextElement();
            String deliveredMsgId = (String)this.deliveredIds.remove(id);
            if (deliveredMsgId == null) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)(this + ": cannot deny message: " + id));
                continue;
            }
            this.save();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ": deny message: " + id));
            }
            if ((message = (Message)this.messagesTable.get(id)) == null) continue;
            Integer value = (Integer)this.deniedMsgs.get(id);
            if (value != null) {
                deliveryAttempts = value + 1;
            }
            if (this.isUndeliverable(deliveryAttempts)) {
                this.deniedMsgs.remove(id);
                message.setDeliveryCount(deliveryAttempts);
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, null);
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
                this.decrAckCounters(id, message);
                continue;
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> put back to the messages to deliver");
            }
            int i = 0;
            while (i < this.messageIds.size()) {
                String currentId = (String)this.messageIds.elementAt(i);
                Message currentMessage = (Message)this.messagesTable.get(currentId);
                if (currentMessage != null) {
                    long currentO = currentMessage.order;
                    if (currentO > message.order) break;
                    ++i;
                    continue;
                }
                this.messageIds.removeElementAt(i);
            }
            this.messageIds.insertElementAt(id, i);
            this.deniedMsgs.put(id, new Integer(deliveryAttempts));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    void delete() {
        Enumeration e = this.deliveredIds.keys();
        while (e.hasMoreElements()) {
            this.messageIds.add(e.nextElement());
        }
        Enumeration allMessageIds = this.messageIds.elements();
        while (allMessageIds.hasMoreElements()) {
            this.removeMessage((String)allMessageIds.nextElement());
        }
    }

    private boolean isUndeliverable(int deliveryAttempts) {
        if (this.threshold != null) {
            return deliveryAttempts == this.threshold;
        }
        if (QueueImpl.getDefaultThreshold() != null) {
            return deliveryAttempts == QueueImpl.getDefaultThreshold();
        }
        return false;
    }

    public long getNbMsgsSentToDMQSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation;
    }

    public long getNbMsgsDeliveredSinceCreation() {
        return this.nbMsgsDeliveredSinceCreation;
    }

    public TabularData getMessagesTabularData() throws Exception {
        return MessageJMXWrapper.createTabularDataSupport(this.messagesTable.elements());
    }

    Message getMessage(String msgId) {
        int index;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription.getMessage(" + msgId + ')'));
        }
        if ((index = this.messageIds.indexOf(msgId)) < 0) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> message not found");
            }
            return null;
        }
        return (Message)this.messagesTable.get(msgId);
    }

    public void deleteMessage(String msgId) {
        this.messageIds.remove(msgId);
        Message message = this.removeMessage(msgId);
        this.save();
        if (message != null) {
            DMQManager dmqManager = new DMQManager(this.dmqId, null);
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
            dmqManager.sendToDMQ();
        }
    }

    public void clear() {
        DMQManager dmqManager = null;
        for (int i = 0; i < this.messageIds.size(); ++i) {
            String msgId = (String)this.messageIds.elementAt(i);
            Message message = this.removeMessage(msgId);
            if (message == null) continue;
            if (dmqManager == null) {
                dmqManager = new DMQManager(this.dmqId, null);
            }
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.messageIds.clear();
        this.save();
    }

    Message removeMessage(String msgId) {
        Message message = (Message)this.messagesTable.get(msgId);
        if (message != null) {
            this.decrAckCounters(msgId, message);
        }
        return message;
    }

    private void decrAckCounters(String msgId, Message message) {
        --message.acksCounter;
        if (message.acksCounter == 0) {
            this.messagesTable.remove(msgId);
        }
        if (this.durable) {
            --message.durableAcksCounter;
            if (message.durableAcksCounter == 0) {
                message.delete();
            }
        }
    }

    private void save() {
        if (this.durable) {
            this.proxy.setSave();
        }
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this.proxyId + "].readbag()"));
        }
        this.contextId = in.readInt();
        this.subRequestId = in.readInt();
        this.noLocal = in.readBoolean();
        this.noFiltering = in.readBoolean();
        this.active = in.readBoolean();
        this.requestId = in.readInt();
        this.toListener = in.readBoolean();
        this.requestExpTime = in.readLong();
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this.proxyId + "].writeBag()"));
        }
        out.writeInt(this.contextId);
        out.writeInt(this.subRequestId);
        out.writeBoolean(this.noLocal);
        out.writeBoolean(this.noFiltering);
        out.writeBoolean(this.active);
        out.writeInt(this.requestId);
        out.writeBoolean(this.toListener);
        out.writeLong(this.requestExpTime);
    }

    void cleanMessageIds() {
        this.messageIds.retainAll(this.messagesTable.keySet());
    }
}

