/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.interceptor.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.ow2.carol.rmi.interceptor.api.JClientRequestInfo;
import org.ow2.carol.rmi.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.interceptor.spi.JServiceContext;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JContextStore;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPClientRequestInfoImpl;
import org.ow2.carol.util.configuration.TraceCarol;

public class JClientInterceptorHelper
extends JInterceptorHelper {
    public static void send_request(ObjectOutput out, JClientRequestInterceptor[] cis, boolean localRef) throws IOException {
        if (cis == null || cis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request without interceptors");
            }
            out.writeInt(0);
        } else {
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            for (int i = 0; i < cis.length; ++i) {
                cis[i].sendRequest((JClientRequestInfo)jrc);
            }
            JClientInterceptorHelper.setClientContextInOutput(out, jrc, localRef);
        }
        out.flush();
    }

    public static void send_poll(ObjectOutput out, JClientRequestInterceptor[] cis, boolean localRef) throws IOException {
    }

    public static void receive_reply(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive reply without interceptors");
                }
                JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive reply contexts");
                }
                JClientRequestInfo ri = JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
                for (int i = 0; i < cis.length; ++i) {
                    cis[i].receiveReply(ri);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void receive_exception(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive exception without interceptors");
                }
                JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive exception contexts");
                }
                JClientRequestInfo ri = JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
                for (int i = 0; i < cis.length; ++i) {
                    cis[i].receiveException(ri);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void receive_other(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive other without interceptors");
                }
                JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive other contexts");
                }
                JClientRequestInfo ri = JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
                for (int i = 0; i < cis.length; ++i) {
                    cis[i].receiveOther(ri);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static JClientRequestInfo getClientRequestContextFromInput(ObjectInput in, int ctxValue, JClientRequestInfo jrc) throws ClassNotFoundException, IOException {
        if (ctxValue == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput no context");
            }
            return jrc;
        }
        if (ctxValue == 1) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput remote");
            }
            int sz = in.readInt();
            for (int i = 0; i < sz; ++i) {
                jrc.addRequestServiceContext((JServiceContext)in.readObject());
            }
            return jrc;
        }
        if (ctxValue == 2) {
            int id = in.readInt();
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput local id(" + id + ")");
            }
            jrc.addAllRequestServiceContext((Collection)JContextStore.getObject(id));
            return jrc;
        }
        throw new IOException("Unknow context type:" + ctxValue);
    }

    public static void setClientContextInOutput(ObjectOutput out, JClientRequestInfo ri, boolean locRef) throws IOException {
        block6: {
            block7: {
                block5: {
                    if (ri.hasContexts()) break block5;
                    if (TraceCarol.isDebugRmiCarol()) {
                        TraceCarol.debugRmiCarol("JClientInterceptorHelper send request without contexts");
                    }
                    out.writeInt(0);
                    break block6;
                }
                if (!locRef) break block7;
                Collection ctx = ri.getAllRequestServiceContext();
                int k = JContextStore.storeObject(ctx);
                out.writeInt(2);
                out.writeInt(k);
                if (!TraceCarol.isDebugRmiCarol()) break block6;
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with local contexts id(" + k + ")");
                for (JServiceContext jsc : ctx) {
                    TraceCarol.debugRmiCarol("ctx:" + jsc);
                }
                break block6;
            }
            out.writeInt(1);
            Collection allCtx = ri.getAllRequestServiceContext();
            out.writeInt(allCtx.size());
            for (JServiceContext jsc : allCtx) {
                out.writeObject(jsc);
            }
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with remote contexts");
                for (JServiceContext jsc : allCtx) {
                    TraceCarol.debugRmiCarol("ctx:" + jsc);
                }
            }
        }
    }
}

