/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.registry.carol;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.carol.jndi.spi.VirtualJNDIContextFactory;
import org.ow2.carol.jndi.spi.VirtualJNDILookup;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.OSGiClassLoader;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.registry.carol.delegate.ORBCCFDelegate;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarolRegistryService
extends AbsServiceImpl
implements RegistryService,
Pojo {
    private InstanceManager __IM;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.registry");
    public static final String DEFAULT_MODE = "automatic";
    public static final String COLLOCATED = "collocated";
    public static final String REMOTE = "remote";
    private boolean __FbStartRegistry;
    private boolean bStartRegistry;
    private boolean __FbIgnoreError;
    private boolean bIgnoreError;
    private boolean __Fdelegate;
    private JComponentContextFactoryDelegate delegate;
    private boolean __Ffactory;
    private JComponentContextFactory factory;
    private boolean __FconfigurationURL;
    private URL configurationURL;
    private boolean __FmbeanServer;
    private MBeanServer mbeanServer;
    private boolean __FdeploymentPlanDeployer;
    private DeploymentPlanDeployer deploymentPlanDeployer;
    private boolean __Fictx;
    private InitialContext ictx;
    private static final String SECURITY_PROPAGATION = "jonas.security.propagation";
    private static final String CSIV2_PROPAGATION = "jonas.csiv2.propagation";
    private static final String TRANSACTION_PROPAGATION = "jonas.transaction.propagation";
    private boolean __MsetMode$java_lang_String;
    private boolean __MdoStart;
    private boolean __MinitInterceptors;
    private boolean __MdoStop;
    private boolean __MgetActiveProtocolNames;
    private boolean __MgetDefaultProtocolName;
    private boolean __MgetExportedObjectPort$java_lang_String;
    private boolean __MgetInitialContextFactoryName$java_lang_String;
    private boolean __MgetProviderURL$java_lang_String;
    private boolean __MsetDefaultProtocol$java_lang_String;
    private boolean __MgetProtocolConfiguration$java_lang_String;
    private boolean __MsetComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory;
    private boolean __MsetDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate;
    private boolean __MsetStartRegistry$boolean;
    private boolean __MsetIgnoreError$boolean;
    private boolean __MsetConfigurationURL$java_net_URL;
    private boolean __MsetConfiguration$java_lang_String;
    private boolean __MgetRegistryContext;
    private boolean __MgetMBeanServerId;
    private boolean __MsetMbeanServer$javax_management_MBeanServer;
    private boolean __MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer;
    private boolean __MsetVersioningService$org_ow2_jonas_versioning_VersioningService;
    private boolean __MunsetVersioningService;
    private boolean __MgetVersioningService;

    boolean __getbStartRegistry() {
        if (!this.__FbStartRegistry) {
            return this.bStartRegistry;
        }
        Object object = this.__IM.onGet((Object)this, "bStartRegistry");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setbStartRegistry(boolean bl) {
        if (!this.__FbStartRegistry) {
            this.bStartRegistry = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "bStartRegistry", (Object)bl2);
    }

    boolean __getbIgnoreError() {
        if (!this.__FbIgnoreError) {
            return this.bIgnoreError;
        }
        Object object = this.__IM.onGet((Object)this, "bIgnoreError");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setbIgnoreError(boolean bl) {
        if (!this.__FbIgnoreError) {
            this.bIgnoreError = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "bIgnoreError", (Object)bl2);
    }

    JComponentContextFactoryDelegate __getdelegate() {
        if (!this.__Fdelegate) {
            return this.delegate;
        }
        return (JComponentContextFactoryDelegate)this.__IM.onGet((Object)this, "delegate");
    }

    void __setdelegate(JComponentContextFactoryDelegate jComponentContextFactoryDelegate) {
        if (!this.__Fdelegate) {
            this.delegate = jComponentContextFactoryDelegate;
            return;
        }
        this.__IM.onSet((Object)this, "delegate", (Object)jComponentContextFactoryDelegate);
    }

    JComponentContextFactory __getfactory() {
        if (!this.__Ffactory) {
            return this.factory;
        }
        return (JComponentContextFactory)this.__IM.onGet((Object)this, "factory");
    }

    void __setfactory(JComponentContextFactory jComponentContextFactory) {
        if (!this.__Ffactory) {
            this.factory = jComponentContextFactory;
            return;
        }
        this.__IM.onSet((Object)this, "factory", (Object)jComponentContextFactory);
    }

    URL __getconfigurationURL() {
        if (!this.__FconfigurationURL) {
            return this.configurationURL;
        }
        return (URL)this.__IM.onGet((Object)this, "configurationURL");
    }

    void __setconfigurationURL(URL uRL) {
        if (!this.__FconfigurationURL) {
            this.configurationURL = uRL;
            return;
        }
        this.__IM.onSet((Object)this, "configurationURL", (Object)uRL);
    }

    MBeanServer __getmbeanServer() {
        if (!this.__FmbeanServer) {
            return this.mbeanServer;
        }
        return (MBeanServer)this.__IM.onGet((Object)this, "mbeanServer");
    }

    void __setmbeanServer(MBeanServer mBeanServer) {
        if (!this.__FmbeanServer) {
            this.mbeanServer = mBeanServer;
            return;
        }
        this.__IM.onSet((Object)this, "mbeanServer", (Object)mBeanServer);
    }

    DeploymentPlanDeployer __getdeploymentPlanDeployer() {
        if (!this.__FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (DeploymentPlanDeployer)this.__IM.onGet((Object)this, "deploymentPlanDeployer");
    }

    void __setdeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = deploymentPlanDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deploymentPlanDeployer", (Object)deploymentPlanDeployer);
    }

    InitialContext __getictx() {
        if (!this.__Fictx) {
            return this.ictx;
        }
        return (InitialContext)this.__IM.onGet((Object)this, "ictx");
    }

    void __setictx(InitialContext initialContext) {
        if (!this.__Fictx) {
            this.ictx = initialContext;
            return;
        }
        this.__IM.onSet((Object)this, "ictx", (Object)initialContext);
    }

    public CarolRegistryService() {
        this(null);
    }

    private CarolRegistryService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setbStartRegistry(true);
        this.__setbIgnoreError(true);
        this.__setdelegate(null);
        this.__setfactory(null);
        this.__setmbeanServer(null);
        this.__setdeploymentPlanDeployer(null);
        this.__setictx(null);
    }

    public void setMode(String string) {
        if (!this.__MsetMode$java_lang_String) {
            this.__setMode(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMode$java_lang_String", new Object[]{string});
            this.__setMode(string);
            this.__IM.onExit((Object)this, "setMode$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMode$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setMode(String mode) {
        if (DEFAULT_MODE.equalsIgnoreCase(mode)) {
            this.setStartRegistry(true);
            this.setIgnoreError(true);
        } else if (COLLOCATED.equalsIgnoreCase(mode)) {
            this.setStartRegistry(true);
            this.setIgnoreError(false);
        } else if (REMOTE.equalsIgnoreCase(mode)) {
            this.setStartRegistry(false);
            this.setIgnoreError(false);
        }
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting Carol Registry Service");
        Object exec = new IExecution<Void>(){

            public Void execute() throws Exception {
                System.setProperty("carol.server.mode", "true");
                try {
                    ConfigurationRepository.init(CarolRegistryService.this.__getconfigurationURL(), CarolRegistryService.this.getDomainName(), CarolRegistryService.this.getJonasServerName(), CarolRegistryService.this.getMBeanServerId());
                }
                catch (ConfigurationException e) {
                    throw new ServiceException("Cannot init Carol", (Throwable)e);
                }
                if (CarolRegistryService.this.getProtocolConfiguration("irmi") != null) {
                    CarolRegistryService.this.__getdeploymentPlanDeployer().deploy("irmi");
                }
                try {
                    PortableRemoteObject.narrow(null, null);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.DEBUG, (Object)"PortableRemoteObject initialized");
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)exec);
        if (result.hasException()) {
            throw new ServiceException(result.getException().getMessage(), (Throwable)result.getException());
        }
        try {
            this.initInterceptors();
        }
        catch (ConfigurationException e) {
            throw new ServiceException("Cannot init Carol interceptors", (Throwable)e);
        }
        exec = new IExecution<Void>(){

            public Void execute() throws Exception {
                if (CarolRegistryService.this.__getbStartRegistry()) {
                    NameServiceManager nameServiceManager = NameServiceManager.getNameServiceManager();
                    try {
                        if (CarolRegistryService.this.__getbIgnoreError()) {
                            nameServiceManager.startNonStartedNS();
                        } else {
                            nameServiceManager.startNS();
                        }
                    }
                    catch (Exception e) {
                        throw new ServiceException("Cannot start the registry", (Throwable)e);
                    }
                }
                return null;
            }
        };
        result = RunnableHelper.execute((ClassLoader)new OSGiClassLoader(), (IExecution)exec);
        if (result.hasException()) {
            throw new ServiceException(result.getException().getMessage(), (Throwable)result.getException());
        }
        try {
            this.setDelegate(new ORBCCFDelegate());
            this.__getfactory().addDelegate(this.__getdelegate());
        }
        catch (NamingException e) {
            throw new ServiceException("Cannot add the delegate", (Throwable)e);
        }
        VirtualJNDIContextFactory.parent = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", VirtualJNDIContextFactory.class.getName());
        logger.log(BasicLevel.INFO, (Object)"Carol Registry Service started");
    }

    private void initInterceptors() throws ConfigurationException {
        if (!this.__MinitInterceptors) {
            this.__initInterceptors();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initInterceptors", new Object[0]);
            this.__initInterceptors();
            this.__IM.onExit((Object)this, "initInterceptors", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initInterceptors", throwable);
            throw throwable;
        }
    }

    private void __initInterceptors() throws ConfigurationException {
        boolean security = Boolean.parseBoolean(this.getServerProperties().getValue(SECURITY_PROPAGATION));
        boolean transaction = Boolean.parseBoolean(this.getServerProperties().getValue(TRANSACTION_PROPAGATION));
        boolean csiv2 = Boolean.parseBoolean(this.getServerProperties().getValue(CSIV2_PROPAGATION));
        boolean iiopEnabled = ConfigurationRepository.getConfiguration("iiop") != null;
        boolean deploySecurityInterceptors = false;
        if (security && iiopEnabled) {
            deploySecurityInterceptors = true;
            ConfigurationRepository.addInterceptors("iiop", "org.ow2.jonas.security.interceptors.iiop.SecurityInitializer");
        }
        if (iiopEnabled && csiv2) {
            deploySecurityInterceptors = true;
            ConfigurationRepository.addInterceptors("iiop", "org.ow2.jonas.security.iiop.Csiv2Initializer");
        }
        if (deploySecurityInterceptors) {
            try {
                this.__getdeploymentPlanDeployer().deploy("sec-interceptors-iiop");
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        if (transaction && iiopEnabled) {
            try {
                this.__getdeploymentPlanDeployer().deploy("trans-interceptors-iiop");
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            ConfigurationRepository.addInterceptors("iiop", "org.ow2.jonas.tm.jotm.ots.OTSORBInitializer");
        }
    }

    public void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Stopping Carol Registry Service");
        try {
            NameServiceManager.getNameServiceManager().stopNS();
        }
        catch (Exception e) {
            throw new ServiceException("Problem when stopping registry service", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)"Carol Registry Service stopped");
    }

    public List<String> getActiveProtocolNames() {
        List<String> list;
        if (!this.__MgetActiveProtocolNames) {
            return this.__getActiveProtocolNames();
        }
        try {
            this.__IM.onEntry((Object)this, "getActiveProtocolNames", new Object[0]);
            list = this.__getActiveProtocolNames();
            this.__IM.onExit((Object)this, "getActiveProtocolNames", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getActiveProtocolNames", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getActiveProtocolNames() {
        ArrayList<String> protocols = new ArrayList<String>();
        ProtocolConfiguration[] configs = ConfigurationRepository.getConfigurations();
        for (int i = 0; i < configs.length; ++i) {
            protocols.add(configs[i].getName());
        }
        return protocols;
    }

    public String getDefaultProtocolName() {
        String string;
        if (!this.__MgetDefaultProtocolName) {
            return this.__getDefaultProtocolName();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultProtocolName", new Object[0]);
            string = this.__getDefaultProtocolName();
            this.__IM.onExit((Object)this, "getDefaultProtocolName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultProtocolName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultProtocolName() {
        return ConfigurationRepository.getDefaultConfiguration().getName();
    }

    public int getExportedObjectPort(String string) {
        int n;
        if (!this.__MgetExportedObjectPort$java_lang_String) {
            return this.__getExportedObjectPort(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getExportedObjectPort$java_lang_String", new Object[]{string});
            n = this.__getExportedObjectPort(string);
            this.__IM.onExit((Object)this, "getExportedObjectPort$java_lang_String", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExportedObjectPort$java_lang_String", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getExportedObjectPort(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        String key = "carol." + protocolName + ".server.port";
        String port = config.getProperties().getProperty(key, "0");
        return Integer.valueOf(port);
    }

    public String getInitialContextFactoryName(String string) {
        String string2;
        if (!this.__MgetInitialContextFactoryName$java_lang_String) {
            return this.__getInitialContextFactoryName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getInitialContextFactoryName$java_lang_String", new Object[]{string});
            string2 = this.__getInitialContextFactoryName(string);
            this.__IM.onExit((Object)this, "getInitialContextFactoryName$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInitialContextFactoryName$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getInitialContextFactoryName(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        return config.getProtocol().getInitialContextFactoryClassName();
    }

    public URI getProviderURL(String string) {
        URI uRI;
        if (!this.__MgetProviderURL$java_lang_String) {
            return this.__getProviderURL(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getProviderURL$java_lang_String", new Object[]{string});
            uRI = this.__getProviderURL(string);
            this.__IM.onExit((Object)this, "getProviderURL$java_lang_String", (Object)uRI);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProviderURL$java_lang_String", throwable);
            throw throwable;
        }
        return uRI;
    }

    private URI __getProviderURL(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        return URI.create(config.getProviderURL());
    }

    public void setDefaultProtocol(String string) {
        if (!this.__MsetDefaultProtocol$java_lang_String) {
            this.__setDefaultProtocol(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDefaultProtocol$java_lang_String", new Object[]{string});
            this.__setDefaultProtocol(string);
            this.__IM.onExit((Object)this, "setDefaultProtocol$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDefaultProtocol$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setDefaultProtocol(String protocolName) {
        ProtocolConfiguration config = this.getProtocolConfiguration(protocolName);
        ConfigurationRepository.setCurrentConfiguration(config);
    }

    private ProtocolConfiguration getProtocolConfiguration(String string) {
        ProtocolConfiguration protocolConfiguration;
        if (!this.__MgetProtocolConfiguration$java_lang_String) {
            return this.__getProtocolConfiguration(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getProtocolConfiguration$java_lang_String", new Object[]{string});
            protocolConfiguration = this.__getProtocolConfiguration(string);
            this.__IM.onExit((Object)this, "getProtocolConfiguration$java_lang_String", (Object)protocolConfiguration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProtocolConfiguration$java_lang_String", throwable);
            throw throwable;
        }
        return protocolConfiguration;
    }

    private ProtocolConfiguration __getProtocolConfiguration(String protocolName) {
        return ConfigurationRepository.getConfiguration(protocolName);
    }

    public void setComponentContextFactory(JComponentContextFactory jComponentContextFactory) {
        if (!this.__MsetComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory) {
            this.__setComponentContextFactory(jComponentContextFactory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory", new Object[]{jComponentContextFactory});
            this.__setComponentContextFactory(jComponentContextFactory);
            this.__IM.onExit((Object)this, "setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory", throwable);
            throw throwable;
        }
    }

    private void __setComponentContextFactory(JComponentContextFactory factory) {
        this.__setfactory(factory);
    }

    public void setDelegate(JComponentContextFactoryDelegate jComponentContextFactoryDelegate) {
        if (!this.__MsetDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate) {
            this.__setDelegate(jComponentContextFactoryDelegate);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate", new Object[]{jComponentContextFactoryDelegate});
            this.__setDelegate(jComponentContextFactoryDelegate);
            this.__IM.onExit((Object)this, "setDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate", throwable);
            throw throwable;
        }
    }

    private void __setDelegate(JComponentContextFactoryDelegate delegate) {
        this.__setdelegate(delegate);
    }

    public void setStartRegistry(boolean bl) {
        if (!this.__MsetStartRegistry$boolean) {
            this.__setStartRegistry(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setStartRegistry$boolean", new Object[]{new Boolean(bl)});
            this.__setStartRegistry(bl);
            this.__IM.onExit((Object)this, "setStartRegistry$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setStartRegistry$boolean", throwable);
            throw throwable;
        }
    }

    private void __setStartRegistry(boolean startRegistry) {
        this.__setbStartRegistry(startRegistry);
    }

    public void setIgnoreError(boolean bl) {
        if (!this.__MsetIgnoreError$boolean) {
            this.__setIgnoreError(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setIgnoreError$boolean", new Object[]{new Boolean(bl)});
            this.__setIgnoreError(bl);
            this.__IM.onExit((Object)this, "setIgnoreError$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setIgnoreError$boolean", throwable);
            throw throwable;
        }
    }

    private void __setIgnoreError(boolean ignoreError) {
        this.__setbIgnoreError(ignoreError);
    }

    public void setConfigurationURL(URL uRL) {
        if (!this.__MsetConfigurationURL$java_net_URL) {
            this.__setConfigurationURL(uRL);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationURL$java_net_URL", new Object[]{uRL});
            this.__setConfigurationURL(uRL);
            this.__IM.onExit((Object)this, "setConfigurationURL$java_net_URL", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationURL$java_net_URL", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationURL(URL configurationURL) {
        this.__setconfigurationURL(configurationURL);
    }

    public void setConfiguration(String string) throws MalformedURLException {
        if (!this.__MsetConfiguration$java_lang_String) {
            this.__setConfiguration(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfiguration$java_lang_String", new Object[]{string});
            this.__setConfiguration(string);
            this.__IM.onExit((Object)this, "setConfiguration$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfiguration$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setConfiguration(String configurationURL) throws MalformedURLException {
        this.setConfigurationURL(new URL(configurationURL));
    }

    public InitialContext getRegistryContext() {
        InitialContext initialContext;
        if (!this.__MgetRegistryContext) {
            return this.__getRegistryContext();
        }
        try {
            this.__IM.onEntry((Object)this, "getRegistryContext", new Object[0]);
            initialContext = this.__getRegistryContext();
            this.__IM.onExit((Object)this, "getRegistryContext", (Object)initialContext);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRegistryContext", throwable);
            throw throwable;
        }
        return initialContext;
    }

    private InitialContext __getRegistryContext() {
        if (this.__getictx() == null) {
            IExecution<InitialContext> ie = new IExecution<InitialContext>(){

                public InitialContext execute() throws Exception {
                    return new InitialContext();
                }
            };
            ExecutionResult result = null;
            result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)ie);
            if (result.hasException()) {
                logger.log(BasicLevel.ERROR, (Object)result.getException());
            }
            this.__setictx((InitialContext)result.getResult());
        }
        return this.__getictx();
    }

    private String getMBeanServerId() throws ServiceException {
        String string;
        if (!this.__MgetMBeanServerId) {
            return this.__getMBeanServerId();
        }
        try {
            this.__IM.onEntry((Object)this, "getMBeanServerId", new Object[0]);
            string = this.__getMBeanServerId();
            this.__IM.onExit((Object)this, "getMBeanServerId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMBeanServerId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getMBeanServerId() throws ServiceException {
        try {
            ObjectName on = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            return (String)this.__getmbeanServer().getAttribute(on, "MBeanServerId");
        }
        catch (Exception e) {
            throw new ServiceException("MBeanServerId cannot be retrieved", (Throwable)e);
        }
    }

    public void setMbeanServer(MBeanServer mBeanServer) {
        if (!this.__MsetMbeanServer$javax_management_MBeanServer) {
            this.__setMbeanServer(mBeanServer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMbeanServer$javax_management_MBeanServer", new Object[]{mBeanServer});
            this.__setMbeanServer(mBeanServer);
            this.__IM.onExit((Object)this, "setMbeanServer$javax_management_MBeanServer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMbeanServer$javax_management_MBeanServer", throwable);
            throw throwable;
        }
    }

    private void __setMbeanServer(MBeanServer mbeanServer) {
        this.__setmbeanServer(mbeanServer);
    }

    public void setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer) {
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", new Object[]{deploymentPlanDeployer});
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            this.__IM.onExit((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", throwable);
            throw throwable;
        }
    }

    private void __setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        this.__setdeploymentPlanDeployer(deploymentPlanDeployer);
    }

    public void setVersioningService(VersioningService versioningService) {
        if (!this.__MsetVersioningService$org_ow2_jonas_versioning_VersioningService) {
            this.__setVersioningService(versioningService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setVersioningService$org_ow2_jonas_versioning_VersioningService", new Object[]{versioningService});
            this.__setVersioningService(versioningService);
            this.__IM.onExit((Object)this, "setVersioningService$org_ow2_jonas_versioning_VersioningService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setVersioningService$org_ow2_jonas_versioning_VersioningService", throwable);
            throw throwable;
        }
    }

    private void __setVersioningService(VersioningService versioningService) {
        VirtualJNDILookup.setVersioningService(versioningService);
    }

    public void unsetVersioningService() {
        if (!this.__MunsetVersioningService) {
            this.__unsetVersioningService();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unsetVersioningService", new Object[0]);
            this.__unsetVersioningService();
            this.__IM.onExit((Object)this, "unsetVersioningService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unsetVersioningService", throwable);
            throw throwable;
        }
    }

    private void __unsetVersioningService() {
        VirtualJNDILookup.unsetVersioningService();
    }

    public VersioningService getVersioningService() {
        VersioningService versioningService;
        if (!this.__MgetVersioningService) {
            return this.__getVersioningService();
        }
        try {
            this.__IM.onEntry((Object)this, "getVersioningService", new Object[0]);
            versioningService = this.__getVersioningService();
            this.__IM.onExit((Object)this, "getVersioningService", (Object)versioningService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVersioningService", throwable);
            throw throwable;
        }
        return versioningService;
    }

    private VersioningService __getVersioningService() {
        return VirtualJNDILookup.getVersioningService();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this.__FdeploymentPlanDeployer = true;
            }
            if (set.contains("configurationURL")) {
                this.__FconfigurationURL = true;
            }
            if (set.contains("delegate")) {
                this.__Fdelegate = true;
            }
            if (set.contains("ictx")) {
                this.__Fictx = true;
            }
            if (set.contains("bStartRegistry")) {
                this.__FbStartRegistry = true;
            }
            if (set.contains("mbeanServer")) {
                this.__FmbeanServer = true;
            }
            if (set.contains("bIgnoreError")) {
                this.__FbIgnoreError = true;
            }
            if (set.contains("factory")) {
                this.__Ffactory = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setMode$java_lang_String")) {
                this.__MsetMode$java_lang_String = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("initInterceptors")) {
                this.__MinitInterceptors = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getActiveProtocolNames")) {
                this.__MgetActiveProtocolNames = true;
            }
            if (set.contains("getDefaultProtocolName")) {
                this.__MgetDefaultProtocolName = true;
            }
            if (set.contains("getExportedObjectPort$java_lang_String")) {
                this.__MgetExportedObjectPort$java_lang_String = true;
            }
            if (set.contains("getInitialContextFactoryName$java_lang_String")) {
                this.__MgetInitialContextFactoryName$java_lang_String = true;
            }
            if (set.contains("getProviderURL$java_lang_String")) {
                this.__MgetProviderURL$java_lang_String = true;
            }
            if (set.contains("setDefaultProtocol$java_lang_String")) {
                this.__MsetDefaultProtocol$java_lang_String = true;
            }
            if (set.contains("getProtocolConfiguration$java_lang_String")) {
                this.__MgetProtocolConfiguration$java_lang_String = true;
            }
            if (set.contains("setComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory")) {
                this.__MsetComponentContextFactory$org_ow2_jonas_naming_JComponentContextFactory = true;
            }
            if (set.contains("setDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate")) {
                this.__MsetDelegate$org_ow2_jonas_naming_JComponentContextFactoryDelegate = true;
            }
            if (set.contains("setStartRegistry$boolean")) {
                this.__MsetStartRegistry$boolean = true;
            }
            if (set.contains("setIgnoreError$boolean")) {
                this.__MsetIgnoreError$boolean = true;
            }
            if (set.contains("setConfigurationURL$java_net_URL")) {
                this.__MsetConfigurationURL$java_net_URL = true;
            }
            if (set.contains("setConfiguration$java_lang_String")) {
                this.__MsetConfiguration$java_lang_String = true;
            }
            if (set.contains("getRegistryContext")) {
                this.__MgetRegistryContext = true;
            }
            if (set.contains("getMBeanServerId")) {
                this.__MgetMBeanServerId = true;
            }
            if (set.contains("setMbeanServer$javax_management_MBeanServer")) {
                this.__MsetMbeanServer$javax_management_MBeanServer = true;
            }
            if (set.contains("setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer")) {
                this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer = true;
            }
            if (set.contains("setVersioningService$org_ow2_jonas_versioning_VersioningService")) {
                this.__MsetVersioningService$org_ow2_jonas_versioning_VersioningService = true;
            }
            if (set.contains("unsetVersioningService")) {
                this.__MunsetVersioningService = true;
            }
            if (set.contains("getVersioningService")) {
                this.__MgetVersioningService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

