/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.apt.dispatch.IProcessorProvider;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;

public class RoundDispatcher {
    private final Set<TypeElement> _unclaimedAnnotations;
    private final RoundEnvironment _roundEnv;
    private final IProcessorProvider _provider;
    private boolean _searchForStar = false;
    private final List<ProcessorInfo> _processors;

    public RoundDispatcher(IProcessorProvider provider, RoundEnvironment env, Set<TypeElement> rootAnnotations) {
        this._provider = provider;
        this._processors = provider.getDiscoveredProcessors();
        this._roundEnv = env;
        this._unclaimedAnnotations = new HashSet<TypeElement>(rootAnnotations);
    }

    public void round() {
        this._searchForStar = this._unclaimedAnnotations.isEmpty();
        for (ProcessorInfo pi : this._processors) {
            this.handleProcessor(pi);
        }
        while (this._searchForStar || !this._unclaimedAnnotations.isEmpty()) {
            ProcessorInfo pi;
            pi = this._provider.discoverNextProcessor();
            if (pi == null) break;
            this.handleProcessor(pi);
        }
    }

    private void handleProcessor(ProcessorInfo pi) {
        try {
            HashSet<TypeElement> annotationsToProcess = new HashSet<TypeElement>();
            boolean shouldCall = pi.computeSupportedAnnotations(this._unclaimedAnnotations, annotationsToProcess);
            if (shouldCall && pi._processor.process(annotationsToProcess, this._roundEnv)) {
                this._unclaimedAnnotations.removeAll(annotationsToProcess);
                if (pi.supportsStar()) {
                    this._searchForStar = false;
                }
            }
        }
        catch (Exception e) {
            this._provider.reportProcessorException(pi._processor, e);
        }
    }
}

