/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.sandbox.security.trust2.SecurityTokenMessage;
import org.apache.ws.sandbox.security.trust2.SecurityTokenOrReference;
import org.apache.ws.sandbox.security.trust2.exception.ElementParsingException;
import org.apache.ws.sandbox.security.trust2.exception.NoRequestType;
import org.apache.ws.sandbox.security.trust2.exception.TrustException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequestSecurityToken
extends SecurityTokenMessage {
    protected URI requestType = null;
    protected SecurityTokenOrReference base = null;
    protected List supporting = new ArrayList();

    public RequestSecurityToken(Document doc, URI requestType) {
        super(doc);
        this.requestType = requestType;
    }

    public RequestSecurityToken(Element element) throws ElementParsingException {
        super(element);
        this.initialize(element);
    }

    public RequestSecurityToken(Element element, Document document) throws ElementParsingException {
        super(element, document);
        this.initialize(element);
    }

    private void initialize(Element element) throws ElementParsingException {
        ArrayList elements = (ArrayList)this.customElements.clone();
        this.customElements.clear();
        for (int i = 0; i < elements.size(); ++i) {
            Element currentNode = (Element)elements.get(i);
            if (!"http://schemas.xmlsoap.org/ws/2004/04/trust".equals(currentNode.getNamespaceURI())) {
                this.addCustomElement(currentNode);
                continue;
            }
            if (currentNode.getLocalName().equals("RequestType")) {
                String textContent = this.getTextContent(currentNode);
                if (textContent == null || textContent.equals("")) continue;
                try {
                    this.setRequestType(new URI(textContent));
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new ElementParsingException("URISyntaxException while creating RequestSecurityToken (RequestType) from XML Element: " + e.getMessage());
                }
            }
            if (currentNode.getLocalName().equals("Base")) {
                Element elem = this.getFirstNonBlankChildAsElement(currentNode);
                if (elem == null) continue;
                this.setBase(new SecurityTokenOrReference(elem, this.doc));
                continue;
            }
            if (currentNode.getLocalName().equals("Supporting")) {
                NodeList supportingNodes = currentNode.getChildNodes();
                if (supportingNodes == null) continue;
                for (int j = 0; j < supportingNodes.getLength(); ++j) {
                    if (supportingNodes.item(j).getLocalName() == null) continue;
                    this.addSupporting(new SecurityTokenOrReference((Element)supportingNodes.item(j), this.doc));
                }
                continue;
            }
            this.addCustomElement(currentNode);
        }
    }

    public void setRequestType(URI requestType) {
        this.requestType = requestType;
    }

    public URI getRequestType() {
        return this.requestType;
    }

    public void setBase(SecurityTokenOrReference base) {
        this.base = base;
    }

    public SecurityTokenOrReference getBase() {
        return this.base;
    }

    public void addSupporting(SecurityTokenOrReference supportingToken) {
        this.supporting.add(supportingToken);
    }

    public List getSupporting() {
        return this.supporting;
    }

    public Element getElement() throws TrustException {
        Element wstElement = this.getElement("wst:RequestSecurityToken");
        if (this.requestType == null) {
            throw new NoRequestType("RequestType is a required element that cannot be null.");
        }
        Element requestTypeElement = this.doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:RequestType");
        this.setTextContent(requestTypeElement, this.requestType.toString());
        wstElement.appendChild(requestTypeElement);
        if (this.base != null) {
            wstElement.appendChild(this.createTokenOrReferenceElement("wst:Base", this.base));
        }
        if (!this.supporting.isEmpty()) {
            Element supportingElement = this.doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Supporting");
            Iterator itr = this.supporting.iterator();
            while (itr.hasNext()) {
                SecurityTokenOrReference next = (SecurityTokenOrReference)itr.next();
                supportingElement.appendChild(next.getElement());
            }
            wstElement.appendChild(supportingElement);
        }
        return wstElement;
    }
}

