/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SAMLRequest
extends SAMLSignedObject
implements Cloneable {
    protected String requestId = new SAMLIdentifier().toString();
    protected Date issueInstant = new Date();
    protected ArrayList respondWiths = new ArrayList();
    protected SAMLQuery query = null;
    protected ArrayList assertionIdRefs = new ArrayList();
    protected ArrayList artifacts = new ArrayList();

    protected void insertSignature() throws SAMLException {
        Element element = XML.getFirstChildElement(this.root);
        while (element != null && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            element = XML.getNextSiblingElement(element);
        }
        this.root.insertBefore(this.getSignatureElement(), element);
    }

    public SAMLRequest() {
    }

    public SAMLRequest(Collection collection, SAMLQuery sAMLQuery, Collection collection2, Collection collection3) throws SAMLException {
        this.query = sAMLQuery;
        if (collection2 != null) {
            this.assertionIdRefs.addAll(collection2);
        }
        if (collection3 != null) {
            this.artifacts.addAll(collection3);
        }
        if (collection != null) {
            this.respondWiths.addAll(collection);
        }
    }

    public SAMLRequest(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLRequest(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLRequest.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Request")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLRequest.fromDOM() requires samlp:Request at root");
        }
        if (Integer.parseInt(element.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLRequest() detected incompatible request major version of " + element.getAttributeNS(null, "MajorVersion"));
        }
        this.requestId = element.getAttributeNS(null, "RequestID");
        element.setIdAttributeNode(element.getAttributeNodeNS(null, "RequestID"), true);
        try {
            object = null;
            String string = element.getAttributeNS(null, "IssueInstant");
            int n = string.indexOf(46);
            object = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
            this.issueInstant = ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest() detected an invalid datetime while parsing request", (Exception)parseException);
        }
        object = XML.getFirstChildElement(element);
        while (object != null && XML.isElementNamed((Element)object, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            this.respondWiths.add(QName.getQNameTextNode((Text)object.getFirstChild()));
            object = XML.getNextSiblingElement((Node)object);
        }
        if (XML.isElementNamed((Element)object, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
            object = XML.getNextSiblingElement((Node)object);
        }
        if (XML.isElementNamed((Element)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
            while (object != null) {
                this.assertionIdRefs.add(object.getFirstChild().getNodeValue());
                object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
            }
        } else if (XML.isElementNamed((Element)object, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")) {
            while (object != null) {
                this.artifacts.add(object.getFirstChild().getNodeValue());
                object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
            }
        } else {
            this.query = SAMLQuery.getInstance((Element)object);
        }
        this.checkValidity();
    }

    public String getId() {
        return this.requestId;
    }

    public void setId(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.requestId = string;
        if (this.root != null) {
            this.unsign();
            ((Element)this.root).getAttributeNodeNS(null, "RequestID").setNodeValue(string);
        }
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        if (this.root != null) {
            this.unsign();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            ((Element)this.root).getAttributeNodeNS(null, "IssueInstant").setNodeValue(simpleDateFormat.format(date));
        }
        this.issueInstant = date;
    }

    public Iterator getRespondWiths() {
        return this.respondWiths.iterator();
    }

    public void setRespondWiths(Collection collection) {
        while (this.respondWiths.size() > 0) {
            this.removeRespondWith(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addRespondWith((QName)iterator.next());
            }
        }
    }

    public void addRespondWith(QName qName) {
        if (qName != null) {
            if (this.root != null) {
                this.unsign();
                Element element = this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
                String string = qName.getNamespaceURI();
                if (string == null) {
                    string = "";
                }
                if (!"urn:oasis:names:tc:SAML:1.0:assertion".equals(string)) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rw", string);
                    string = "rw:";
                } else {
                    string = "saml:";
                }
                element.appendChild(this.root.getOwnerDocument().createTextNode(string + qName.getLocalName()));
                Element element2 = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
                if (element2 == null) {
                    this.root.insertBefore(element, this.root.getFirstChild());
                } else {
                    this.root.insertBefore(element, element2.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("respondWith cannot be null");
        }
        this.respondWiths.add(qName);
    }

    public void removeRespondWith(int n) throws IndexOutOfBoundsException {
        this.respondWiths.remove(n);
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public SAMLQuery getQuery() {
        return this.query;
    }

    public void setQuery(SAMLQuery sAMLQuery) throws SAMLException {
        if (sAMLQuery != null) {
            this.setAssertionIdRefs(null);
            this.setArtifacts(null);
        }
        if (this.root != null) {
            this.unsign();
            Element element = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            if (sAMLQuery != null) {
                if (this.query != null) {
                    this.root.replaceChild(sAMLQuery.toDOM(this.root.getOwnerDocument()), this.query.root);
                } else if (element == null) {
                    this.root.insertBefore(sAMLQuery.toDOM(this.root.getOwnerDocument()), this.root.getFirstChild());
                } else {
                    this.root.insertBefore(sAMLQuery.toDOM(this.root.getOwnerDocument()), element.getNextSibling());
                }
            } else {
                this.root.removeChild(this.query.root);
            }
        }
        this.query = sAMLQuery;
    }

    public Iterator getAssertionIdRefs() {
        return this.assertionIdRefs.iterator();
    }

    public void addAssertionIdRef(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("ref cannot be null or empty");
        }
        try {
            this.setQuery(null);
            this.setArtifacts(null);
        }
        catch (SAMLException sAMLException) {
            // empty catch block
        }
        if (this.root != null) {
            this.unsign();
            Document document = this.root.getOwnerDocument();
            Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AssertionIDReference");
            element.appendChild(document.createTextNode(string));
            Element element2 = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            if (element2 == null) {
                this.root.insertBefore(element, this.root.getFirstChild());
            } else {
                this.root.insertBefore(element, element2.getNextSibling());
            }
        }
        this.assertionIdRefs.add(string);
    }

    public void setAssertionIdRefs(Collection collection) {
        while (this.assertionIdRefs.size() > 0) {
            this.removeAssertionIdRef(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAssertionIdRef((String)iterator.next());
            }
        }
    }

    public void removeAssertionIdRef(int n) throws IndexOutOfBoundsException {
        this.assertionIdRefs.remove(n);
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Iterator getArtifacts() {
        return this.artifacts.iterator();
    }

    public void setArtifacts(Collection collection) {
        while (this.artifacts.size() > 0) {
            this.removeArtifact(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addArtifact((String)iterator.next());
            }
        }
    }

    public void addArtifact(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("artifact cannot be null or empty");
        }
        try {
            this.setQuery(null);
            this.setAssertionIdRefs(null);
        }
        catch (SAMLException sAMLException) {
            // empty catch block
        }
        if (this.root != null) {
            this.unsign();
            Document document = this.root.getOwnerDocument();
            Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
            element.appendChild(document.createTextNode(string));
            Element element2 = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            if (element2 == null) {
                this.root.insertBefore(element, this.root.getFirstChild());
            } else {
                this.root.insertBefore(element, element2.getNextSibling());
            }
        }
        this.artifacts.add(string);
    }

    public void removeArtifact(int n) throws IndexOutOfBoundsException {
        this.artifacts.remove(n);
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        element.setAttributeNS(null, "MajorVersion", "1");
        element.setAttributeNS(null, "MinorVersion", this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? "0" : "1");
        element.setAttributeNS(null, "RequestID", this.requestId);
        element.setIdAttributeNS(null, "RequestID", true);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        element.setAttributeNS(null, "IssueInstant", simpleDateFormat.format(this.issueInstant));
        Iterator iterator = this.respondWiths.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            String string = qName.getNamespaceURI();
            if (string == null) {
                string = "";
            }
            if (!"urn:oasis:names:tc:SAML:1.0:assertion".equals(string)) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rw", string);
                string = "rw:";
            } else {
                string = "saml:";
            }
            element2.appendChild(document.createTextNode(string + qName.getLocalName()));
            element.appendChild(element2);
        }
        if (this.query != null) {
            element.appendChild(this.query.toDOM(document, false));
        } else if (this.assertionIdRefs.size() > 0) {
            iterator = this.assertionIdRefs.iterator();
            while (iterator.hasNext()) {
                element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AssertionIDReference")).appendChild(document.createTextNode((String)iterator.next()));
            }
        } else {
            iterator = this.artifacts.iterator();
            while (iterator.hasNext()) {
                element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")).appendChild(document.createTextNode((String)iterator.next()));
            }
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.query == null && this.assertionIdRefs.size() == 0 && this.artifacts.size() == 0) {
            throw new MalformedException("Request is invalid, must have Query, assertion references, or artifacts");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLRequest sAMLRequest = (SAMLRequest)super.clone();
        sAMLRequest.respondWiths = (ArrayList)this.respondWiths.clone();
        sAMLRequest.query = (SAMLQuery)this.query.clone();
        sAMLRequest.assertionIdRefs = (ArrayList)this.assertionIdRefs.clone();
        sAMLRequest.artifacts = (ArrayList)this.artifacts.clone();
        return sAMLRequest;
    }
}

