/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.VMContext;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.VMProxyArg;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.visitor.VMReferenceMungeVisitor;
import org.apache.velocity.util.StringUtils;

public class VelocimacroProxy
extends Directive {
    private String macroName = "";
    private String macroBody = "";
    private String[] argArray = null;
    private SimpleNode nodeTree = null;
    private int numMacroArgs = 0;
    private String namespace = "";
    private boolean init = false;
    private String[] callingArgs;
    private int[] callingArgTypes;
    private HashMap proxyArgHash = new HashMap();

    public String getName() {
        return this.macroName;
    }

    public int getType() {
        return 2;
    }

    public void setName(String name) {
        this.macroName = name;
    }

    public void setArgArray(String[] arr) {
        this.argArray = arr;
        this.numMacroArgs = this.argArray.length - 1;
    }

    public void setNodeTree(SimpleNode tree) {
        this.nodeTree = tree;
    }

    public int getNumArgs() {
        return this.numMacroArgs;
    }

    public void setMacrobody(String mb) {
        this.macroBody = mb;
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException {
        try {
            if (this.nodeTree != null) {
                if (!this.init) {
                    this.nodeTree.init(context, this.rsvc);
                    this.init = true;
                }
                VMContext vmc = new VMContext(context, this.rsvc);
                int i = 1;
                while (i < this.argArray.length) {
                    VMProxyArg arg = (VMProxyArg)this.proxyArgHash.get(this.argArray[i]);
                    vmc.addVMProxyArg(arg);
                    ++i;
                }
                this.nodeTree.render(vmc, writer);
            } else {
                this.rsvc.error("VM error : " + this.macroName + ". Null AST");
            }
        }
        catch (Exception e) {
            if (e instanceof MethodInvocationException) {
                throw (MethodInvocationException)e;
            }
            this.rsvc.error("VelocimacroProxy.render() : exception VM = #" + this.macroName + "() : " + StringUtils.stackTrace(e));
        }
        return true;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
        int i = node.jjtGetNumChildren();
        if (this.getNumArgs() != i) {
            this.rsvc.error("VM #" + this.macroName + ": error : too " + (this.getNumArgs() > i ? "few" : "many") + " arguments to macro. Wanted " + this.getNumArgs() + " got " + i);
            return;
        }
        this.callingArgs = this.getArgArray(node);
        this.setupMacro(this.callingArgs, this.callingArgTypes);
    }

    public boolean setupMacro(String[] callArgs, int[] callArgTypes) {
        this.setupProxyArgs(callArgs, callArgTypes);
        this.parseTree(callArgs);
        return true;
    }

    private void parseTree(String[] callArgs) {
        try {
            BufferedReader br = new BufferedReader(new StringReader(this.macroBody));
            this.nodeTree = this.rsvc.parse(br, this.namespace, false);
            HashMap<String, String> hm = new HashMap<String, String>();
            int i = 1;
            while (i < this.argArray.length) {
                String arg = callArgs[i - 1];
                if (arg.charAt(0) == '$') {
                    hm.put(this.argArray[i], arg);
                }
                ++i;
            }
            VMReferenceMungeVisitor v = new VMReferenceMungeVisitor(hm);
            this.nodeTree.jjtAccept(v, null);
        }
        catch (Exception e) {
            this.rsvc.error("VelocimacroManager.parseTree() : exception " + this.macroName + " : " + StringUtils.stackTrace(e));
        }
    }

    private void setupProxyArgs(String[] callArgs, int[] callArgTypes) {
        int i = 1;
        while (i < this.argArray.length) {
            VMProxyArg arg = new VMProxyArg(this.rsvc, this.argArray[i], callArgs[i - 1], callArgTypes[i - 1]);
            this.proxyArgHash.put(this.argArray[i], arg);
            ++i;
        }
    }

    private String[] getArgArray(Node node) {
        int numArgs = node.jjtGetNumChildren();
        String[] args = new String[numArgs];
        this.callingArgTypes = new int[numArgs];
        int i = 0;
        Token t = null;
        Token tLast = null;
        while (i < numArgs) {
            args[i] = "";
            this.callingArgTypes[i] = node.jjtGetChild(i).getType();
            t = node.jjtGetChild(i).getFirstToken();
            tLast = node.jjtGetChild(i).getLastToken();
            while (t != tLast) {
                int n = i;
                args[n] = args[n] + t.image;
                t = t.next;
            }
            int n = i++;
            args[n] = args[n] + t.image;
        }
        return args;
    }
}

