/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mi2xml.lib;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.objectweb.jorm.api.JormConfigurator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.mi2xml.api.DomtreeBuilder;
import org.objectweb.jorm.mi2xml.api.MappingDomtreeBuilder;
import org.objectweb.jorm.mi2xml.lib.BasicDomtreeBuilder;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.w3c.dom.Document;

public class BasicDomWriter
implements org.objectweb.jorm.mi2xml.api.Writer,
Loggable {
    private static final String ENCODING = "ISO-8859-1";
    private static final String DOCTYPE_PUBLIC = "-//ObjectWeb Consortium//DTD JORM DEFINITIONS 2.0//EN";
    private static final String JORM_DTD = "http://www.objectweb.org/jorm/dtds/jorm2.dtd";
    public static final String XML_INDENT = "4";
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private DomtreeBuilder domtreeBuilder;

    public void init(JormConfigurator compilerConfigurator) throws PException {
        this.domtreeBuilder = new BasicDomtreeBuilder();
        ((Loggable)this.domtreeBuilder).setLoggerFactory(this.loggerFactory);
        ((Loggable)this.domtreeBuilder).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.mi2xml."));
        Iterator it = compilerConfigurator.knownMappers();
        while (it.hasNext()) {
            String mappername = (String)it.next();
            this.logger.log(BasicLevel.DEBUG, (Object)("Register specific mapping domtree builder for mapper [" + mappername + "]"));
            MappingDomtreeBuilder mdb = compilerConfigurator.getMappingDomtreeBuilder(mappername);
            ((Loggable)mdb).setLoggerFactory(this.loggerFactory);
            ((Loggable)mdb).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.mi2xml." + mappername));
            this.domtreeBuilder.addMappingDomtreeBuilder(mappername, mdb);
        }
    }

    public void write(MetaObject mo, TargetHolder holder) throws PException {
        String moFQName = null;
        String moFileName = null;
        String name = null;
        if (mo instanceof Class) {
            moFQName = ((Class)mo).getFQName();
            moFileName = ((Class)mo).getFileName();
            name = ((Class)mo).getName();
        } else if (mo instanceof CompositeName) {
            moFQName = ((CompositeName)mo).getFQName();
            name = ((CompositeName)mo).getName();
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("FQName():" + moFQName + " / filename=[" + moFileName + "]"));
        this.logger.log(BasicLevel.DEBUG, (Object)"let's build the domtree !");
        Document domTree = this.domtreeBuilder.build(mo);
        this.logger.log(BasicLevel.DEBUG, (Object)(name + "DOMTree generated"));
        String fileName = File.separatorChar + name;
        String packName = ((Package)mo.getParent()).getName();
        if (packName != null && packName.length() > 0) {
            fileName = packName + File.separatorChar + fileName;
            fileName = fileName.replace('.', File.separatorChar);
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Generate " + fileName + ".pd"));
        this.write(domTree, holder, fileName);
    }

    private void write(Document domTree, TargetHolder holder, String fileName) throws PException {
        try {
            OutputFormat outf = new OutputFormat(domTree);
            outf.setIndenting(true);
            outf.setIndent(Integer.parseInt(XML_INDENT));
            outf.setOmitXMLDeclaration(false);
            outf.setEncoding(ENCODING);
            outf.setDoctype(DOCTYPE_PUBLIC, JORM_DTD);
            FileWriter fw = holder.getFileWriter(fileName + ".pd");
            BufferedWriter buf = new BufferedWriter(fw);
            XMLSerializer xmls = new XMLSerializer((Writer)buf, outf);
            xmls.asDOMSerializer();
            xmls.serialize(domTree);
            fw.flush();
            fw.close();
            this.logger.log(BasicLevel.DEBUG, (Object)(fileName + ".pd generated"));
        }
        catch (Exception e) {
            throw new PException(e, "Problem while writing .pd file.");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
        this.loggerFactory = loggerfactory;
        if (this.logger == null && this.loggerFactory != null) {
            this.logger = this.loggerFactory.getLogger("org.objectweb.jorm.mi2xml.rdb");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }
}

