/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.lib;

import java.util.List;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.api.UnevaluableExpressionException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;

public class MemberOf
extends BasicOperator
implements Operator {
    public MemberOf(List left, List right) throws MalformedExpressionException {
        super(PTypeSpace.BOOLEAN);
        int size = left.size();
        if (right.size() != size) {
            throw new MalformedExpressionException("Left list has size " + size + " whereas right list has size " + right.size() + ". They should be the same.");
        }
        this.expressions = new Expression[size * 2];
        for (int i = 0; i < size; ++i) {
            this.expressions[i] = (Expression)left.get(i);
            this.expressions[i + size] = (Expression)right.get(i);
            if (!(this.expressions[i] instanceof FieldOperand)) continue;
            QueryTree qt1 = ((QueryTreeField)((FieldOperand)this.expressions[i]).getField()).getQueryTree();
            QueryTree qt2 = ((QueryTreeField)((FieldOperand)this.expressions[i + size]).getField()).getQueryTree();
            if (qt1 instanceof QueryLeaf || qt1 != qt2) continue;
            throw new MalformedExpressionException("The MemberOf fields may not be built on the same QueryTree " + qt1);
        }
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        throw new UnevaluableExpressionException("Unevaluable Expression: MemberOf currently not implemented");
    }

    public Operand compileExpression() throws TypingException, MalformedExpressionException {
        if (this.expressions == null) {
            throw new MalformedExpressionException("null children value");
        }
        this.result = new BasicVariableOperand(this.type);
        this.verified = true;
        return this.result;
    }

    public Operand getResult() throws IllegalStateException {
        if (this.verified) {
            return this.result;
        }
        throw new IllegalStateException("Can't get result of an uncompiled expression");
    }

    public String getOperatorString() {
        return "memberof";
    }
}

