/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.BinaryLogicalOperator;
import org.objectweb.medor.expression.api.BinaryOperator;
import org.objectweb.medor.expression.api.Comparator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.ConditionalAnd;
import org.objectweb.medor.expression.lib.ConditionalOr;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.Greater;
import org.objectweb.medor.expression.lib.GreaterEqual;
import org.objectweb.medor.expression.lib.Lower;
import org.objectweb.medor.expression.lib.LowerEqual;
import org.objectweb.medor.expression.lib.Not;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.expression.lib.Or;
import org.objectweb.medor.filter.lib.IsNull;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.util.monolog.api.BasicLevel;

public class PushNotInExpressionRule
extends BasicRule {
    public PushNotInExpressionRule() {
        super("PushNotInExpressionRule");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        if (qt instanceof FilteredQueryTree) {
            BasicRule.ModifiedExpression me = this.pushNotInExpression(((FilteredQueryTree)qt).getQueryFilter(), false);
            if (me.isModified) {
                ((FilteredQueryTree)qt).setQueryFilter(me.e);
            }
        }
        if (qt instanceof QueryNode) {
            QueryTree[] children = ((QueryNode)qt).getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.rewrite(children[i], (QueryNode)qt);
            }
        }
        return qt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BasicRule.ModifiedExpression pushNotInExpression(Expression e, boolean hasANot) throws MedorException {
        this.log.log(BasicLevel.DEBUG, (Object)("pushNotInExpression: (" + hasANot + ", exp:" + e + ")"));
        BasicRule.ModifiedExpression me = new BasicRule.ModifiedExpression(e, false);
        if (hasANot && e instanceof Comparator) {
            Expression l = ((BinaryOperator)e).getExpression(0);
            Expression r = ((BinaryOperator)e).getExpression(1);
            me.isModified = true;
            if (e instanceof Equal) {
                me.e = new NotEqual(l, r);
                return me;
            } else if (e instanceof NotEqual) {
                me.e = new Equal(l, r);
                return me;
            } else if (e instanceof Lower) {
                me.e = new GreaterEqual(l, r);
                return me;
            } else if (e instanceof GreaterEqual) {
                me.e = new Lower(l, r);
                return me;
            } else if (e instanceof LowerEqual) {
                me.e = new Greater(l, r);
                return me;
            } else {
                if (!(e instanceof Greater)) throw new MedorException("Comparator unmanaged by this method: " + e);
                me.e = new LowerEqual(l, r);
            }
            return me;
        } else {
            if (e instanceof Not) {
                Expression inner = ((Not)e).getExpression(0);
                if (!(inner instanceof Not)) return this.pushNotInExpression(inner, !hasANot);
                BasicRule.ModifiedExpression _me = this.pushNotInExpression(((Not)inner).getExpression(0), hasANot);
                me.isModified = true;
                me.e = _me.e;
                return me;
            }
            if (e instanceof IsNull) {
                if (!hasANot) return me;
                ((IsNull)me.e).setNot(!((IsNull)me.e).getNot());
                me.isModified = true;
                return me;
            } else if (e instanceof BinaryLogicalOperator) {
                BasicRule.ModifiedExpression lme = this.pushNotInExpression(((BinaryOperator)e).getExpression(0), hasANot);
                BasicRule.ModifiedExpression rme = this.pushNotInExpression(((BinaryOperator)e).getExpression(1), hasANot);
                if (hasANot) {
                    me.isModified = true;
                    if (e instanceof And) {
                        me.e = new Or(lme.e, rme.e);
                        return me;
                    } else if (e instanceof ConditionalAnd) {
                        me.e = new ConditionalOr(lme.e, rme.e);
                        return me;
                    } else if (e instanceof Or) {
                        me.e = new And(lme.e, rme.e);
                        return me;
                    } else {
                        if (!(e instanceof ConditionalOr)) throw new MedorException("BinaryLogicalOperator unmanaged by this method: " + e);
                        me.e = new ConditionalAnd(lme.e, rme.e);
                    }
                    return me;
                } else {
                    if (lme.isModified) {
                        ((BinaryOperator)e).setExpression(0, lme.e);
                    }
                    if (rme.isModified) {
                        ((BinaryOperator)e).setExpression(1, rme.e);
                    }
                    me.isModified = lme.isModified || rme.isModified;
                }
                return me;
            } else {
                if (!hasANot || e.getType().getTypeCode() != 0) return me;
                me.e = new Not(e);
                me.isModified = true;
            }
        }
        return me;
    }
}

