/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.tuple.lib;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.clone.api.Cloneable;
import org.objectweb.medor.clone.lib.BasicCloneable;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;
import org.objectweb.medor.tuple.lib.TupleCollectionView;

public class ExplicitTupleCollection
extends BasicCloneable
implements TupleCollection {
    private TupleStructure schema;
    private List tuples;
    private int cursor;
    boolean top = true;
    boolean end = false;
    boolean closed = false;

    public ExplicitTupleCollection() {
    }

    public ExplicitTupleCollection(TupleStructure schema) throws MedorException {
        this.schema = schema;
        this.tuples = new LinkedList();
        this.cursor = 0;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ExplicitTupleCollection tc = (ExplicitTupleCollection)clone;
        tc.closed = this.closed;
        tc.end = this.end;
        tc.top = this.top;
        tc.cursor = this.cursor;
        tc.schema = (TupleStructure)ExplicitTupleCollection.getClone(this.schema, obj2clone);
        if (this.tuples != null) {
            this.tuples = new LinkedList();
            Iterator it = this.tuples.iterator();
            while (it.hasNext()) {
                tc.tuples.add(ExplicitTupleCollection.getClone((Cloneable)it.next(), obj2clone));
            }
        }
        return clone;
    }

    public void close() throws MedorException {
        this.closed = true;
    }

    public synchronized TupleStructure getMetaData() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.schema;
    }

    public synchronized boolean isEmpty() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.tuples.size() == 0;
    }

    public synchronized boolean isLast() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.cursor == -1 || this.tuples.size() == 0) {
            throw new MedorException(" No elements fetched in this tupleCollection");
        }
        return this.tuples.size() == this.getRow();
    }

    public synchronized int size() {
        return this.tuples.size();
    }

    public synchronized boolean next() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.tuples.size() != 0) {
            if (this.cursor == this.tuples.size()) {
                this.end = true;
                return false;
            }
            if (this.top) {
                this.cursor = 1;
                this.top = false;
                return true;
            }
            ++this.cursor;
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws MedorException {
        boolean prev = true;
        if (!this.isEmpty()) {
            if (this.end) {
                this.end = false;
                prev = true;
            } else if (this.getRow() == 1) {
                this.top = true;
                prev = false;
            } else {
                --this.cursor;
                prev = true;
            }
        } else {
            prev = false;
        }
        return prev;
    }

    public synchronized boolean row(int row) throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (row >= 1 && row <= this.tuples.size()) {
            this.cursor = row;
            return true;
        }
        return false;
    }

    public synchronized void first() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (!this.isEmpty()) {
            this.end = false;
            this.top = false;
            this.cursor = 1;
        }
    }

    public synchronized int getRow() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.isEmpty() || this.top || this.end) {
            return -1;
        }
        return this.cursor;
    }

    public synchronized void insertTuple(int i, Tuple T) throws MedorException {
        if (i < 1 || i > this.size()) {
            throw new MedorException("its impossible to insert in this cursor: " + i);
        }
        this.tuples.add(i - 1, T);
    }

    public synchronized void insertTuple(Tuple T) throws MedorException {
        this.tuples.add(T);
    }

    public synchronized void removeTuple(int row) throws MedorException {
        if (row >= 1 && row <= this.size()) {
            this.tuples.remove(row - 1);
            if (this.tuples.size() == 0) {
                this.end = false;
                this.cursor = -1;
            } else {
                this.cursor = row - 1;
            }
        } else {
            throw new MedorException("its impossible to remove from this cursor");
        }
    }

    public synchronized Tuple getTuple(int i) throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (i > 0 && i <= this.tuples.size()) {
            return (Tuple)this.tuples.get(i - 1);
        }
        throw new MedorException("its impossible de get tuple from this cursor " + i);
    }

    public synchronized Tuple getTuple() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (!(this.isEmpty() || this.top || this.end)) {
            return (Tuple)this.tuples.get(this.cursor - 1);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized boolean getBoolean(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getBoolean(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized byte getByte(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getByte(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized Date getDate(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getDate(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized double getDouble(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getInt(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized float getFloat(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getFloat(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized int getInt(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getInt(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized char getChar(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getChar(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized long getLong(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getLong(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized short getShort(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getShort(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized String getString(int i) throws MedorException {
        if (!(this.isEmpty() || this.top || this.end)) {
            return this.getTuple().getString(i);
        }
        throw new MedorException("No elements fetched in this tupleCollection");
    }

    public synchronized void setBoolean(boolean x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setBoolean(x, i);
    }

    public synchronized void setByte(byte x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setByte(x, i);
    }

    public synchronized void setDate(Date x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setDate(x, i);
    }

    public synchronized void setDouble(double x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setDouble(x, i);
        this.tuples.add(i, upletI);
    }

    public synchronized void setFloat(float x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setFloat(x, i);
    }

    public synchronized void setInt(int x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setInt(x, i);
    }

    public synchronized void setShort(short x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setShort(x, i);
    }

    public synchronized void setString(String x, int i) throws MedorException {
        if (this.isEmpty() || this.top || this.end) {
            throw new MedorException("No elements fetched in this tupleCollection");
        }
        Tuple t = this.getTuple();
        MemoryTuple upletI = (MemoryTuple)t;
        upletI.setString(x, i);
    }

    public synchronized boolean contains(Tuple T) {
        return this.tuples.contains(T);
    }

    public synchronized void display() throws MedorException {
        TupleCollectionView frame = new TupleCollectionView(this);
        frame.pack();
        frame.setVisible(true);
    }

    public synchronized Iterator iteratorOf(int i) throws MedorException {
        Object o = this.getTuple().getObject(i);
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return c.iterator();
        }
        throw new MedorException("the Attribute number " + i + " is not a collection Object");
    }

    public synchronized Iterator iteratorAll() throws MedorException {
        return this.tuples.iterator();
    }
}

