/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.util.SocketAddress;
import fr.dyade.aaa.util.SocketFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class StreamNetwork
extends Network {
    int CnxRetry = 3;
    int backlog = 5;
    boolean TcpNoDelay = false;
    int SoLinger = -1;
    int SoTimeout = 0;
    int ConnectTimeout = 0;
    InetAddress inLocalAddr = null;
    int outLocalPort = 0;
    InetAddress outLocalAddr = null;
    SocketFactory socketFactory = null;

    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
    }

    public void setProperties() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.domain + ", StreamNetwork.setProperties()"));
        }
        super.setProperties();
        this.CnxRetry = AgentServer.getInteger("CnxRetry", this.CnxRetry);
        this.CnxRetry = AgentServer.getInteger(this.domain + ".CnxRetry", this.CnxRetry);
        this.backlog = AgentServer.getInteger("backlog", this.backlog);
        this.backlog = AgentServer.getInteger(this.domain + ".backlog", this.backlog);
        this.TcpNoDelay = AgentServer.getBoolean(this.domain + ".TcpNoDelay");
        if (!this.TcpNoDelay) {
            this.TcpNoDelay = AgentServer.getBoolean("TcpNoDelay");
        }
        this.SoLinger = AgentServer.getInteger("SoLinger", this.SoLinger);
        this.SoLinger = AgentServer.getInteger(this.domain + ".SoLinger", this.SoLinger);
        this.SoTimeout = AgentServer.getInteger("SoTimeout", this.SoTimeout);
        this.SoTimeout = AgentServer.getInteger(this.domain + ".SoTimeout", this.SoTimeout);
        this.ConnectTimeout = AgentServer.getInteger("ConnectTimeout", this.ConnectTimeout);
        this.ConnectTimeout = AgentServer.getInteger(this.domain + ".ConnectTimeout", this.ConnectTimeout);
        String inLocalAddressStr = null;
        inLocalAddressStr = AgentServer.getProperty("InLocalAddress", inLocalAddressStr);
        inLocalAddressStr = AgentServer.getProperty(this.domain + ".InLocalAddress", inLocalAddressStr);
        if (inLocalAddressStr != null) {
            this.inLocalAddr = InetAddress.getByName(inLocalAddressStr);
        }
        String outLocalAddressStr = null;
        outLocalAddressStr = AgentServer.getProperty("OutLocalAddress", outLocalAddressStr);
        outLocalAddressStr = AgentServer.getProperty(this.domain + ".OutLocalAddress", outLocalAddressStr);
        if (outLocalAddressStr != null) {
            this.outLocalAddr = InetAddress.getByName(outLocalAddressStr);
        }
        this.outLocalPort = AgentServer.getInteger("OutLocalPort", this.outLocalPort);
        this.outLocalPort = AgentServer.getInteger(this.domain + ".OutLocalPort", this.outLocalPort);
        String sfcn = AgentServer.getProperty("SocketFactory", "fr.dyade.aaa.util.SocketFactory14");
        sfcn = AgentServer.getProperty(this.domain + ".SocketFactory", sfcn);
        this.socketFactory = SocketFactory.getFactory(sfcn);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(" setProperties(");
            strbuf.append("CnxRetry=").append(this.CnxRetry);
            strbuf.append(", backlog=").append(this.backlog);
            strbuf.append(", TcpNoDelay=").append(this.TcpNoDelay);
            strbuf.append(", SoLinger=").append(this.SoLinger);
            strbuf.append(", SoTimeout=").append(this.SoTimeout);
            strbuf.append(", ConnectTimeout=").append(this.ConnectTimeout);
            strbuf.append(", inLocalAddressStr=").append(inLocalAddressStr);
            strbuf.append(", outLocalAddressStr=").append(outLocalAddressStr);
            strbuf.append(", outLocalPort=").append(this.outLocalPort);
            strbuf.append(", sfcn=").append(sfcn);
            strbuf.append(')');
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
        }
    }

    final Socket createSocket(ServerDesc server) throws IOException {
        Enumeration e = server.getSockAddrs();
        while (e.hasMoreElements()) {
            SocketAddress sa = (SocketAddress)e.nextElement();
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", try to connect server#" + server.getServerId() + ", addr=" + sa.getHostname() + ", port=" + sa.getPort()));
            }
            try {
                Socket socket = this.createSocket(sa);
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connected"));
                }
                server.moveToFirst(sa);
                return socket;
            }
            catch (IOException exc) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection refused, try next element"));
            }
        }
        throw new ConnectException("Cannot connect to server#" + server.getServerId());
    }

    final Socket createSocket(SocketAddress addr) throws IOException {
        try {
            return this.createSocket(addr.getAddress(), addr.getPort());
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection refused, reset addr"));
            addr.resetAddr();
            return this.createSocket(addr.getAddress(), addr.getPort());
        }
    }

    Socket createSocket(InetAddress addr, int port) throws IOException {
        if (addr == null) {
            throw new UnknownHostException();
        }
        return this.socketFactory.createSocket(addr, port, this.outLocalAddr, this.outLocalPort, this.ConnectTimeout);
    }

    final ServerSocket createServerSocket() throws IOException {
        int i = 0;
        while (true) {
            try {
                return this.createServerSocket(this.port);
            }
            catch (BindException exc) {
                if (i > this.CnxRetry) {
                    throw exc;
                }
                try {
                    Thread.sleep(i * 200);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port, this.backlog, this.inLocalAddr);
    }

    void setSocketOption(Socket sock) throws SocketException {
        sock.setTcpNoDelay(this.TcpNoDelay);
        sock.setSoTimeout(this.SoTimeout);
        if (this.SoLinger >= 0) {
            sock.setSoLinger(true, this.SoLinger);
        } else {
            sock.setSoLinger(false, 0);
        }
    }
}

