/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.converter.JavaClassToDBCConverter;
import org.apache.axis2.jaxws.description.impl.DescriptionFactoryImpl;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisServiceGenerator {
    private static final Log log = LogFactory.getLog(AxisServiceGenerator.class);
    private MessageReceiver messageReceiver = new JAXWSMessageReceiver();

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    private static boolean isImpl(DescriptionBuilderComposite dbc) {
        return !dbc.isInterface() && (dbc.getWebServiceAnnot() != null || dbc.getWebServiceProviderAnnot() != null);
    }

    public static ServiceDescription createServiceDescription(Class<?> serviceImplClass, ConfigurationContext configurationContext) throws MalformedURLException {
        ServiceDescription serviceDesc = null;
        if (serviceImplClass != null) {
            JavaClassToDBCConverter converter = new JavaClassToDBCConverter(serviceImplClass);
            HashMap dbcMap = converter.produceDBC();
            ArrayList serviceDescriptionList = new ArrayList();
            DescriptionBuilderComposite serviceImplComposite = null;
            for (DescriptionBuilderComposite tmpComposite : dbcMap.values()) {
                if (!AxisServiceGenerator.isImpl(tmpComposite)) continue;
                serviceImplComposite = tmpComposite;
            }
            dbcMap.remove(serviceImplComposite.getClassName());
            URL wsdlURL = null;
            WebService ws = serviceImplClass.getAnnotation(WebService.class);
            wsdlURL = serviceImplClass.getClassLoader().getResource(ws.wsdlLocation());
            if (wsdlURL == null) {
                wsdlURL = new URL(ws.wsdlLocation());
            }
            serviceImplComposite.setwsdlURL(wsdlURL);
            dbcMap.put(serviceImplComposite.getClassName(), serviceImplComposite);
            List serviceDescList = DescriptionFactoryImpl.createServiceDescriptionFromDBCMap((HashMap)dbcMap, (ConfigurationContext)configurationContext);
            if (serviceDescList != null && serviceDescList.size() > 0) {
                serviceDesc = (ServiceDescription)serviceDescList.get(0);
                log.debug((Object)"ServiceDescription created with class: {0}", new Object[]{serviceImplClass});
                log.debug((Object)serviceDesc, new Object[0]);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDesciption was not created for class: " + serviceImplClass), new Object[0]);
                }
                throw ExceptionFactory.makeWebServiceException((String)("A ServiceDescription was not created for " + serviceImplClass));
            }
        }
        return serviceDesc;
    }

    public AxisService getServiceFromClass(Class endpointClass, ConfigurationContext configurationContext) throws Exception {
        ServiceDescription serviceDescription = AxisServiceGenerator.createServiceDescription(endpointClass, configurationContext);
        EndpointDescription[] edArray = serviceDescription.getEndpointDescriptions();
        AxisService service = edArray[0].getAxisService();
        if (service.getNameSpacesMap() == null) {
            NamespaceMap map = new NamespaceMap();
            map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
            map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            service.setNameSpacesMap(map);
        }
        String endpointClassName = endpointClass.getName();
        ClassLoader classLoader = endpointClass.getClassLoader();
        service.addParameter(new Parameter("ServiceClass", (Object)endpointClassName));
        service.setClassLoader(classLoader);
        Iterator opIterator = service.getOperations();
        while (opIterator.hasNext()) {
            AxisOperation operation = (AxisOperation)opIterator.next();
            operation.setMessageReceiver(this.messageReceiver);
        }
        Parameter serviceDescriptionParam = new Parameter("org.apache.axis2.jaxws.description.EndpointDescription", (Object)edArray[0]);
        service.addParameter(serviceDescriptionParam);
        return service;
    }

    public static URL getWsdlURL(String wsdlFile, URL configurationBaseUrl, ClassLoader classLoader) {
        URL wsdlURL;
        block5: {
            wsdlURL = null;
            if (wsdlFile != null) {
                try {
                    wsdlURL = new URL(wsdlFile);
                }
                catch (MalformedURLException e) {
                    wsdlURL = classLoader.getResource(wsdlFile);
                    if (wsdlURL != null || configurationBaseUrl == null) break block5;
                    try {
                        wsdlURL = new URL(configurationBaseUrl, wsdlFile);
                    }
                    catch (MalformedURLException ee) {
                        // empty catch block
                    }
                }
            }
        }
        return wsdlURL;
    }

    public static EndpointDescription getEndpointDescription(AxisService service) {
        Parameter param = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        return param == null ? null : (EndpointDescription)param.getValue();
    }

    public static boolean isSOAP11(AxisService service) {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(service);
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(desc.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(desc.getBindingType());
    }
}

