/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.VersioningServiceBase;
import org.ow2.jonas.versioning.contexts.VirtualJNDIBinding;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private boolean __FdefaultPolicy;
    private String defaultPolicy;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgetPolicies;
    private boolean __MisVersioningEnabled;
    private boolean __MgetDefaultDeploymentPolicy;
    private boolean __MsetDefaultDeploymentPolicy$java_lang_String;
    private boolean __MgetVersionID$java_io_File;
    private boolean __MgetVersionID$java_net_URL;
    private boolean __MgetVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgetPrefix$java_io_File;
    private boolean __MgetPrefix$java_net_URL;
    private boolean __MgetPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MfilterIdentifier$java_lang_String$java_lang_String$java_lang_String;
    private boolean __McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgarbageCollectJNDIBindingMBeans;
    private boolean __MgetBaseName$java_net_URL;

    String __getdefaultPolicy() {
        if (!this.__FdefaultPolicy) {
            return this.defaultPolicy;
        }
        return (String)this.__IM.onGet((Object)this, "defaultPolicy");
    }

    void __setdefaultPolicy(String string) {
        if (!this.__FdefaultPolicy) {
            this.defaultPolicy = string;
            return;
        }
        this.__IM.onSet((Object)this, "defaultPolicy", (Object)string);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    public VersioningServiceImpl() {
        this(null);
    }

    private VersioningServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdefaultPolicy("Reserved");
        this.__setjmxService(null);
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    protected void doStart() {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() {
        VirtualJNDIBinding.initialize(this, this.__getjmxService());
        this.__getjmxService().registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been registered successfully", new Object[0]);
    }

    protected void doStop() {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() {
        this.__getjmxService().unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been unregistered successfully", new Object[0]);
    }

    @Override
    public String[] getPolicies() {
        String[] stringArray;
        if (!this.__MgetPolicies) {
            return this.__getPolicies();
        }
        try {
            this.__IM.onEntry((Object)this, "getPolicies", new Object[0]);
            stringArray = this.__getPolicies();
            this.__IM.onExit((Object)this, "getPolicies", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPolicies", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __getPolicies() {
        return VersioningServiceBase.POLICIES;
    }

    @Override
    public boolean isVersioningEnabled() {
        boolean bl;
        if (!this.__MisVersioningEnabled) {
            return this.__isVersioningEnabled();
        }
        try {
            this.__IM.onEntry((Object)this, "isVersioningEnabled", new Object[0]);
            bl = this.__isVersioningEnabled();
            this.__IM.onExit((Object)this, "isVersioningEnabled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isVersioningEnabled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isVersioningEnabled() {
        return this.isStarted();
    }

    @Override
    public String getDefaultDeploymentPolicy() {
        String string;
        if (!this.__MgetDefaultDeploymentPolicy) {
            return this.__getDefaultDeploymentPolicy();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultDeploymentPolicy", new Object[0]);
            string = this.__getDefaultDeploymentPolicy();
            this.__IM.onExit((Object)this, "getDefaultDeploymentPolicy", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultDeploymentPolicy", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultDeploymentPolicy() {
        return this.__getdefaultPolicy();
    }

    @Override
    public void setDefaultDeploymentPolicy(String string) {
        if (!this.__MsetDefaultDeploymentPolicy$java_lang_String) {
            this.__setDefaultDeploymentPolicy(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDefaultDeploymentPolicy$java_lang_String", new Object[]{string});
            this.__setDefaultDeploymentPolicy(string);
            this.__IM.onExit((Object)this, "setDefaultDeploymentPolicy$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDefaultDeploymentPolicy$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setDefaultDeploymentPolicy(String defaultPolicy) {
        if (!("Default".equals(defaultPolicy) || "Disabled".equals(defaultPolicy) || "Reserved".equals(defaultPolicy) || "Private".equals(defaultPolicy))) {
            throw new IllegalArgumentException("Invalid policy : " + defaultPolicy);
        }
        this.__setdefaultPolicy(defaultPolicy);
    }

    @Override
    public String getVersionID(File file) {
        String string;
        if (!this.__MgetVersionID$java_io_File) {
            return this.__getVersionID(file);
        }
        try {
            this.__IM.onEntry((Object)this, "getVersionID$java_io_File", new Object[]{file});
            string = this.__getVersionID(file);
            this.__IM.onExit((Object)this, "getVersionID$java_io_File", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVersionID$java_io_File", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getVersionID(File file) {
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
            IDeployable deployable = DeployableHelper.getDeployable((IArchive)archive);
            return this.getVersionID(deployable);
        }
        catch (DeployableHelperException e) {
            logger.info((Object)("Failed creating deployable for file " + file), new Object[]{e});
            return null;
        }
    }

    @Override
    public String getVersionID(URL uRL) {
        String string;
        if (!this.__MgetVersionID$java_net_URL) {
            return this.__getVersionID(uRL);
        }
        try {
            this.__IM.onEntry((Object)this, "getVersionID$java_net_URL", new Object[]{uRL});
            string = this.__getVersionID(uRL);
            this.__IM.onExit((Object)this, "getVersionID$java_net_URL", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVersionID$java_net_URL", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getVersionID(URL url) {
        return this.getVersionID(URLUtils.urlToFile((URL)url));
    }

    @Override
    public String getVersionID(IDeployable<?> iDeployable) {
        String string;
        if (!this.__MgetVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getVersionID(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            string = this.__getVersionID(iDeployable);
            this.__IM.onExit((Object)this, "getVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getVersionID(IDeployable<?> deployable) {
        IDeployable<?> originalDeployable = this.getOriginalDeployable(deployable);
        String versionID = originalDeployable.getArchive().getMetadata().get("Implementation-Version");
        if (versionID != null) {
            versionID = "-version" + this.filterIdentifier(versionID, "version ID", originalDeployable.getArchive().getName());
        }
        return versionID;
    }

    @Override
    public String getPrefix(File file) {
        String string;
        if (!this.__MgetPrefix$java_io_File) {
            return this.__getPrefix(file);
        }
        try {
            this.__IM.onEntry((Object)this, "getPrefix$java_io_File", new Object[]{file});
            string = this.__getPrefix(file);
            this.__IM.onExit((Object)this, "getPrefix$java_io_File", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPrefix$java_io_File", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getPrefix(File file) {
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
            IDeployable deployable = DeployableHelper.getDeployable((IArchive)archive);
            return this.getPrefix(deployable);
        }
        catch (DeployableHelperException e) {
            logger.info((Object)("Failed creating deployable for file " + file), new Object[]{e});
            return null;
        }
    }

    @Override
    public String getPrefix(URL uRL) {
        String string;
        if (!this.__MgetPrefix$java_net_URL) {
            return this.__getPrefix(uRL);
        }
        try {
            this.__IM.onEntry((Object)this, "getPrefix$java_net_URL", new Object[]{uRL});
            string = this.__getPrefix(uRL);
            this.__IM.onExit((Object)this, "getPrefix$java_net_URL", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPrefix$java_net_URL", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getPrefix(URL url) {
        return this.getPrefix(URLUtils.urlToFile((URL)url));
    }

    @Override
    public String getPrefix(IDeployable<?> iDeployable) {
        String string;
        if (!this.__MgetPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getPrefix(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            string = this.__getPrefix(iDeployable);
            this.__IM.onExit((Object)this, "getPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getPrefix(IDeployable<?> deployable) {
        String applicationName;
        IDeployable<?> originalDeployable = this.getOriginalDeployable(deployable);
        String versionID = this.getVersionID(originalDeployable);
        if (versionID == null) {
            return null;
        }
        String prefix = applicationName = originalDeployable.getModuleName();
        if (!applicationName.endsWith(versionID)) {
            prefix = prefix + versionID;
        }
        return this.filterIdentifier(prefix, "JNDI prefix", applicationName) + '/';
    }

    private IDeployable<?> getOriginalDeployable(IDeployable<?> iDeployable) {
        IDeployable<?> iDeployable2;
        if (!this.__MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getOriginalDeployable(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            iDeployable2 = this.__getOriginalDeployable(iDeployable);
            this.__IM.onExit((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", iDeployable2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return iDeployable2;
    }

    private IDeployable<?> __getOriginalDeployable(IDeployable<?> deployable) {
        IDeployable originalDeployable = deployable;
        while (originalDeployable.getOriginalDeployable() != null) {
            originalDeployable = originalDeployable.getOriginalDeployable();
        }
        return originalDeployable;
    }

    private String filterIdentifier(String string, String string2, String string3) {
        String string4;
        if (!this.__MfilterIdentifier$java_lang_String$java_lang_String$java_lang_String) {
            return this.__filterIdentifier(string, string2, string3);
        }
        try {
            this.__IM.onEntry((Object)this, "filterIdentifier$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            string4 = this.__filterIdentifier(string, string2, string3);
            this.__IM.onExit((Object)this, "filterIdentifier$java_lang_String$java_lang_String$java_lang_String", (Object)string4);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "filterIdentifier$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string4;
    }

    private String __filterIdentifier(String identifier, String type, String file) {
        boolean identifierFiltered = false;
        StringBuffer identifierFilter = new StringBuffer();
        for (char c : identifier.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                identifierFilter.append(c);
                continue;
            }
            identifierFiltered = true;
            identifierFilter.append('-');
        }
        if (identifierFiltered) {
            String filteredIdentifier = identifierFilter.toString();
            logger.debug((Object)("Invalid characters detected in " + type + " for archive " + file + ", setting " + type + " to " + filteredIdentifier), new Object[0]);
            return filteredIdentifier;
        }
        return identifier;
    }

    @Override
    public void createJNDIBindingMBeans(IDeployable<?> iDeployable) {
        if (!this.__McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__createJNDIBindingMBeans(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__createJNDIBindingMBeans(iDeployable);
            this.__IM.onExit((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __createJNDIBindingMBeans(IDeployable<?> deployable) {
        IDeployable<?> originalDeployable = this.getOriginalDeployable(deployable);
        String versionID = this.getVersionID(originalDeployable);
        if (versionID == null) {
            logger.warn((Object)("IDeployable " + deployable.toString() + " is not versioned! Ignoring call to createJNDIBindingMBeans"), new Object[0]);
            return;
        }
        String applicationName = originalDeployable.getModuleName();
        if (applicationName.endsWith(versionID)) {
            applicationName = applicationName.replace(versionID, "");
        }
        String prefix = this.getPrefix(originalDeployable);
        VirtualJNDIBinding.createJNDIBindingMBeans(applicationName, prefix);
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        if (!this.__MgarbageCollectJNDIBindingMBeans) {
            this.__garbageCollectJNDIBindingMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "garbageCollectJNDIBindingMBeans", new Object[0]);
            this.__garbageCollectJNDIBindingMBeans();
            this.__IM.onExit((Object)this, "garbageCollectJNDIBindingMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "garbageCollectJNDIBindingMBeans", throwable);
            throw throwable;
        }
    }

    private void __garbageCollectJNDIBindingMBeans() {
        VirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
    }

    @Override
    public String getBaseName(URL uRL) {
        String string;
        if (!this.__MgetBaseName$java_net_URL) {
            return this.__getBaseName(uRL);
        }
        try {
            this.__IM.onEntry((Object)this, "getBaseName$java_net_URL", new Object[]{uRL});
            string = this.__getBaseName(uRL);
            this.__IM.onExit((Object)this, "getBaseName$java_net_URL", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBaseName$java_net_URL", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getBaseName(URL url) {
        File file = URLUtils.urlToFile((URL)url);
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
            IDeployable<?> originalDeployable = this.getOriginalDeployable(DeployableHelper.getDeployable((IArchive)archive));
            String moduleName = originalDeployable.getModuleName();
            String versionID = this.getVersionID(originalDeployable);
            if (versionID != null) {
                moduleName = moduleName.replace(versionID, "");
            }
            return moduleName;
        }
        catch (DeployableHelperException e) {
            logger.info((Object)("Failed creating deployable for file " + file), new Object[]{e});
            return null;
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("defaultPolicy")) {
                this.__FdefaultPolicy = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getPolicies")) {
                this.__MgetPolicies = true;
            }
            if (set.contains("isVersioningEnabled")) {
                this.__MisVersioningEnabled = true;
            }
            if (set.contains("getDefaultDeploymentPolicy")) {
                this.__MgetDefaultDeploymentPolicy = true;
            }
            if (set.contains("setDefaultDeploymentPolicy$java_lang_String")) {
                this.__MsetDefaultDeploymentPolicy$java_lang_String = true;
            }
            if (set.contains("getVersionID$java_io_File")) {
                this.__MgetVersionID$java_io_File = true;
            }
            if (set.contains("getVersionID$java_net_URL")) {
                this.__MgetVersionID$java_net_URL = true;
            }
            if (set.contains("getVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetVersionID$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getPrefix$java_io_File")) {
                this.__MgetPrefix$java_io_File = true;
            }
            if (set.contains("getPrefix$java_net_URL")) {
                this.__MgetPrefix$java_net_URL = true;
            }
            if (set.contains("getPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetPrefix$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("filterIdentifier$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MfilterIdentifier$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("garbageCollectJNDIBindingMBeans")) {
                this.__MgarbageCollectJNDIBindingMBeans = true;
            }
            if (set.contains("getBaseName$java_net_URL")) {
                this.__MgetBaseName$java_net_URL = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

