/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.jacc.provider;

import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPolicyConfigurationKeeper {
    private static Map<String, JPolicyConfiguration> policyConfigurations = new HashMap<String, JPolicyConfiguration>();

    private JPolicyConfigurationKeeper() {
    }

    private static Map<String, JPolicyConfiguration> getPolicyConfigurations() {
        if (policyConfigurations == null) {
            policyConfigurations = new HashMap<String, JPolicyConfiguration>();
        }
        return policyConfigurations;
    }

    public static void addConfiguration(JPolicyConfiguration config) {
        try {
            JPolicyConfigurationKeeper.getPolicyConfigurations().put(config.getContextID(), config);
        }
        catch (PolicyContextException pce) {
            throw new RuntimeException("Cannot add the policy configuration object '" + config + "'");
        }
    }

    public static void removeConfiguration(JPolicyConfiguration config) {
        try {
            if (JPolicyConfigurationKeeper.getPolicyConfigurations().containsKey(config.getContextID())) {
                JPolicyConfigurationKeeper.getPolicyConfigurations().remove(config.getContextID());
            }
        }
        catch (PolicyContextException pce) {
            throw new RuntimeException("Cannot remove the policy configuration object '" + config + "'");
        }
    }

    public static JPolicyConfiguration getConfiguration(String contextId) {
        return JPolicyConfigurationKeeper.getPolicyConfigurations().get(contextId);
    }
}

