/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.wsgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.Version;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.wsgen.CheckerException;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;

public class WsGenChecker {
    private static final String AUTO_WSGEN_ENGAGED = "jonas.service.jaxrpc.auto-wsgen.engaged";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ws");
    private String filename = null;
    private MBeanServer mbeanServer = null;
    private ObjectName j2eeServerON;
    private boolean engaged = true;

    public WsGenChecker(String filename, ObjectName j2eeServerON, MBeanServer jmxServer) {
        this.mbeanServer = jmxServer;
        this.filename = filename;
        this.j2eeServerON = j2eeServerON;
        try {
            String[] services = JProp.getInstance().getValueAsArray("jonas.services");
            boolean wsEnabled = false;
            for (int i = 0; i < services.length; ++i) {
                if (!"jaxrpc".equals(services[i])) continue;
                wsEnabled = true;
            }
            this.engaged = wsEnabled && JProp.getInstance().getValue(AUTO_WSGEN_ENGAGED, "true").trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            this.engaged = true;
        }
    }

    public String checkWsGen(String domainName) throws CheckerException {
        if (!this.engaged) {
            return this.filename;
        }
        String jonasVersionWsGen = WsGenChecker.getAttributeInManifest(this.filename, "WsGen-JOnAS-Version");
        if (jonasVersionWsGen == null || !Version.getNumber().equals(jonasVersionWsGen)) {
            if (jonasVersionWsGen == null) {
                logger.log(BasicLevel.DEBUG, (Object)("JOnAS version not found into '" + this.filename + "' manifest file. Trying to generate WebServices classes..."));
            } else if (!Version.getNumber().equals(jonasVersionWsGen)) {
                logger.log(BasicLevel.DEBUG, (Object)("Different JOnAS version found for '" + this.filename + "' (archive version : '" + jonasVersionWsGen + "' / JOnAS version : '" + Version.getNumber() + "'). Trying to re-generate WebServices classes..."));
            }
            File module = new File(this.filename);
            Boolean unpacked = Boolean.FALSE;
            if (module.isDirectory()) {
                unpacked = Boolean.TRUE;
            }
            Object[] param = new Object[]{this.filename, unpacked};
            String[] signature = new String[]{"java.lang.String", "java.lang.Boolean"};
            String path = null;
            try {
                path = (String)this.mbeanServer.invoke(this.j2eeServerON, "wsgenLocalFile", param, signature);
            }
            catch (InstanceNotFoundException e) {
                logger.log(BasicLevel.WARN, (Object)"Cannot find J2EEServer MBean", (Throwable)e);
            }
            catch (MBeanException e) {
                logger.log(BasicLevel.WARN, (Object)"WsGen throw an Exception.", (Throwable)e.getTargetException());
            }
            catch (ReflectionException e) {
                logger.log(BasicLevel.WARN, (Object)"Cannot invoke operation on J2EEServer MBean", (Throwable)e);
            }
            if (path != null) {
                if (path.endsWith(".ear") && this.filename.endsWith(".jar")) {
                    logger.log(BasicLevel.DEBUG, (Object)("WsGen produced an EAR '" + path + "'"));
                    File source = new File(path);
                    File destination = new File(JProp.getJonasBase(), "apps" + File.separator + source.getName());
                    try {
                        FileUtils.copyFile((File)source, (File)destination);
                    }
                    catch (FileUtilsException e) {
                        throw new CheckerException("Cannot copy the file from '" + path + "' to '" + this.filename + "'", e);
                    }
                    logger.log(BasicLevel.DEBUG, (Object)("Deploying '" + path + "' (copied from '" + source.getPath() + "') ..."));
                    try {
                        ObjectName earServiceON = JonasObjectName.earService(domainName);
                        param[0] = path;
                        this.mbeanServer.invoke(earServiceON, "deployEarMBean", param, signature);
                    }
                    catch (InstanceNotFoundException e) {
                        throw new CheckerException("Ear Service not available in this JOnAS instance. Cannot deploy the produced Application : " + path, e);
                    }
                    catch (MBeanException e) {
                        throw new CheckerException("Cannot deploy the produced Application : " + path, e.getTargetException());
                    }
                    catch (ReflectionException e) {
                        throw new CheckerException("Cannot invoke deploy operation on Ear Service MBean for application : " + path, e);
                    }
                    return path;
                }
                logger.log(BasicLevel.DEBUG, (Object)("Archive updated, continuing deployment : " + path));
                try {
                    System.gc();
                    Thread.sleep(Long.getLong("jonas.wsgen.sleep", 100L));
                    if (!FileUtils.delete((String)this.filename)) {
                        throw new CheckerException("Cannot delete old application : " + this.filename);
                    }
                    if (unpacked.booleanValue()) {
                        FileUtils.copyDirectory((File)new File(path), (File)module);
                    } else {
                        FileUtils.copyFile((String)path, (String)this.filename);
                    }
                    FileUtils.delete((String)path);
                }
                catch (FileUtilsException e) {
                    throw new CheckerException("Cannot copy the ear from '" + path + "' to '" + this.filename + "'", e);
                }
                catch (InterruptedException e) {
                    throw new CheckerException("Cannot sleep for the given time period", e);
                }
                return this.filename;
            }
            logger.log(BasicLevel.DEBUG, (Object)("Archive has not been changed, continuing deployment : " + this.filename));
            return this.filename;
        }
        logger.log(BasicLevel.DEBUG, (Object)("Archive up to date, continuing deployment : " + this.filename));
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttributeInManifest(String name, String attributeName) {
        File file = new File(name);
        if (file.isFile()) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                Manifest man = jar.getManifest();
                if (man == null) {
                    String string = null;
                    return string;
                }
                Attributes atts = man.getMainAttributes();
                String e = atts.getValue(attributeName);
                return e;
            }
            catch (IOException ioe) {
                String string = null;
                return string;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        logger.log(BasicLevel.DEBUG, (Object)("Cannot close archive : " + name));
                    }
                }
            }
        }
        try {
            Manifest mf = new Manifest(new FileInputStream(new File(file, "META-INF" + File.separator + "MANIFEST.MF")));
            Attributes atts = mf.getMainAttributes();
            return atts.getValue(attributeName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

