/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import org.jgroups.ReceiverAdapter;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class RoundTripMulticast
extends ReceiverAdapter {
    MulticastSocket mcast_recv_sock;
    MulticastSocket mcast_send_sock;
    DatagramSocket ucast_sock;
    InetAddress bind_addr;
    InetAddress mcast_addr;
    int mcast_port = 7500;
    int num = 1000;
    int msg_size = 10;
    boolean server = false;
    final byte[] RSP_BUF = new byte[]{1};
    int num_responses = 0;
    final Object mutex = new Object();
    IpAddress local_addr;

    private void start(boolean server, int num, int msg_size, InetAddress bind_addr, InetAddress mcast_addr, int mcast_port) throws Exception {
        this.server = server;
        this.num = num;
        this.msg_size = msg_size;
        this.bind_addr = bind_addr;
        this.mcast_addr = mcast_addr;
        this.mcast_port = mcast_port;
        this.mcast_send_sock = new MulticastSocket(mcast_port);
        this.mcast_send_sock.setTimeToLive(2);
        this.mcast_send_sock.setInterface(bind_addr);
        InetSocketAddress group = new InetSocketAddress(mcast_addr, mcast_port);
        this.mcast_send_sock.joinGroup(group, null);
        this.mcast_recv_sock = new MulticastSocket(mcast_port);
        this.mcast_recv_sock.setTimeToLive(2);
        this.mcast_recv_sock.setInterface(bind_addr);
        this.mcast_recv_sock.joinGroup(group, null);
        this.ucast_sock = new DatagramSocket(0, bind_addr);
        this.ucast_sock.setTrafficClass(16);
        this.local_addr = new IpAddress(this.ucast_sock.getLocalAddress(), this.ucast_sock.getLocalPort());
        if (server) {
            Receiver r = new Receiver(){

                public void receive(byte[] buf, int offset, int length, InetAddress sender, int sender_port) {
                    ByteBuffer buffer = ByteBuffer.wrap(buf, offset, length);
                    byte r = buffer.get();
                    short len = buffer.getShort();
                    byte[] tmp = new byte[len];
                    buffer.get(tmp, 0, len);
                    try {
                        IpAddress real_sender = (IpAddress)Util.streamableFromByteBuffer(IpAddress.class, tmp);
                        DatagramPacket packet = new DatagramPacket(RoundTripMulticast.this.RSP_BUF, 0, RoundTripMulticast.this.RSP_BUF.length, real_sender.getIpAddress(), real_sender.getPort());
                        RoundTripMulticast.this.ucast_sock.send(packet);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            ReceiverThread rt = new ReceiverThread(r, this.mcast_recv_sock);
            rt.start();
            System.out.println("server started (ctrl-c to kill)");
            while (true) {
                Util.sleep(60000L);
            }
        }
        System.out.println("sending " + num + " requests");
        this.sendRequests();
        this.mcast_recv_sock.close();
        this.mcast_send_sock.close();
        this.ucast_sock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequests() throws Exception {
        byte[] marshalled_addr = Util.streamableToByteBuffer(this.local_addr);
        int length = 3 + marshalled_addr.length + this.msg_size;
        int print = this.num / 10;
        int count = 0;
        this.num_responses = 0;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put((byte)0);
        buffer.putShort((short)marshalled_addr.length);
        buffer.put(marshalled_addr, 0, marshalled_addr.length);
        byte[] payload = new byte[this.msg_size];
        buffer.put(payload, 0, payload.length);
        byte[] array = buffer.array();
        ReceiverThread mcast_receiver = new ReceiverThread(new Receiver(){

            public void receive(byte[] buffer, int offset, int length, InetAddress sender, int sender_port) {
            }
        }, this.mcast_recv_sock);
        mcast_receiver.start();
        ReceiverThread ucast_receiver = new ReceiverThread(new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(byte[] buffer, int offset, int length, InetAddress sender, int sender_port) {
                Object object = RoundTripMulticast.this.mutex;
                synchronized (object) {
                    ++RoundTripMulticast.this.num_responses;
                    RoundTripMulticast.this.mutex.notify();
                }
            }
        }, this.ucast_sock);
        ucast_receiver.start();
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.num; ++i) {
            DatagramPacket packet = new DatagramPacket(array, 0, array.length, this.mcast_addr, this.mcast_port);
            try {
                this.mcast_send_sock.send(packet);
                Object object = this.mutex;
                synchronized (object) {
                    while (this.num_responses != count + 1) {
                        this.mutex.wait(1000L);
                    }
                    count = this.num_responses;
                    if (this.num_responses >= this.num) {
                        System.out.println("received all responses (" + this.num_responses + ")");
                        break;
                    }
                }
                if (this.num_responses % print != 0) continue;
                System.out.println("- received " + this.num_responses);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long stop = System.currentTimeMillis();
        long total = stop - start;
        double requests_per_sec = (double)this.num / ((double)total / 1000.0);
        double ms_per_req = (double)total / (double)this.num;
        System.out.println("Took " + total + "ms for " + this.num + " requests: " + requests_per_sec + " requests/sec, " + ms_per_req + " ms/request");
    }

    public static void main(String[] args) throws Exception {
        boolean server = false;
        int num = 100;
        int msg_size = 10;
        InetAddress bind_addr = null;
        InetAddress mcast_addr = null;
        int mcast_port = 7500;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-server")) {
                server = true;
                continue;
            }
            if (args[i].equals("-size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bind_addr")) {
                bind_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-mcast_addr")) {
                mcast_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-mcast_port")) {
                mcast_port = Integer.parseInt(args[++i]);
                continue;
            }
            RoundTripMulticast.help();
            return;
        }
        if (bind_addr == null) {
            bind_addr = InetAddress.getLocalHost();
        }
        if (mcast_addr == null) {
            mcast_addr = InetAddress.getByName("225.5.5.5");
        }
        new RoundTripMulticast().start(server, num, msg_size, bind_addr, mcast_addr, mcast_port);
    }

    private static void help() {
        System.out.println("RoundTrip [-server] [-num <number of messages>] [-size <size of each message (in bytes)>] [-bind_addr <bind address>] [-mcast_addr <mcast addr>] [-mcast_port <mcast port>]");
    }

    static class ReceiverThread
    implements Runnable {
        Receiver receiver;
        Thread thread;
        DatagramSocket sock;
        byte[] buf = new byte[65000];
        DatagramPacket packet;

        public ReceiverThread(Receiver r, DatagramSocket sock) {
            this.receiver = r;
            this.sock = sock;
        }

        public final void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
            this.sock.close();
        }

        public void run() {
            while (this.thread != null && this.thread.equals(Thread.currentThread())) {
                this.packet = new DatagramPacket(this.buf, 0, this.buf.length);
                try {
                    this.sock.receive(this.packet);
                    if (this.receiver == null) continue;
                    this.receiver.receive(this.packet.getData(), this.packet.getOffset(), this.packet.getLength(), this.packet.getAddress(), this.packet.getPort());
                }
                catch (IOException e) {
                    break;
                }
            }
        }
    }

    static interface Receiver {
        public void receive(byte[] var1, int var2, int var3, InetAddress var4, int var5);
    }
}

