/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.ns;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.ow2.carol.jndi.ns.AbsRegistry;
import org.ow2.carol.jndi.ns.NameService;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.jndi.registry.jrmp.ManageableRegistry;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationUtil;
import org.ow2.carol.util.configuration.TraceCarol;

public class JRMPRegistry
extends AbsRegistry
implements NameService {
    private static JRMPRegistry singleton = null;
    private static final int DEFAULT_PORT_NUMBER = 1099;
    private static int objectPort = 0;
    private static Registry registry = null;
    private InetAddress registryInetAddress = null;

    public JRMPRegistry() {
        super(1099);
    }

    public void start() throws NameServiceException {
        singleton = this;
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.start() on port:" + this.getPort());
        }
        try {
            if (Boolean.getBoolean("carol.server.mode")) {
                if (this.getConfigProperties() != null) {
                    String propertyName = "carol.jrmp.server.port";
                    objectPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, "0"), propertyName);
                    propertyName = "carol.jrmp.interfaces.bind.single";
                    boolean useSingleItf = Boolean.valueOf(this.getConfigProperties().getProperty(propertyName, "false"));
                    if (useSingleItf) {
                        String url = this.getConfigProperties().getProperty("carol.jrmp.url");
                        this.registryInetAddress = InetAddress.getByName(ConfigurationUtil.getHostOfUrl(url));
                    }
                } else {
                    TraceCarol.debugCarol("No properties 'carol.jrmp.server.port' defined in carol.properties file.");
                }
            }
            if (!this.isStarted()) {
                if (objectPort > 0) {
                    TraceCarol.infoCarol("Using JRMP fixed server port number '" + objectPort + "'.");
                }
                if (this.registryInetAddress != null) {
                    TraceCarol.infoCarol("Using Specific address to bind registry '" + this.registryInetAddress + "'.");
                }
                if (this.getPort() >= 0) {
                    registry = ManageableRegistry.createManagableRegistry(this.getPort(), objectPort, this.registryInetAddress);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                JRMPRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("JRMPRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start JRMPRegistry, port=" + this.getPort() + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JRMPRegistry is already start on port:" + this.getPort());
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start rmi registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.stop()");
        }
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            registry = null;
            System.gc();
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop rmi registry: " + e);
        }
    }

    public static boolean isLocal() {
        return registry != null;
    }

    public boolean isStarted() {
        if (registry != null) {
            return true;
        }
        try {
            if (this.registryInetAddress != null) {
                LocateRegistry.getRegistry(this.registryInetAddress.getHostAddress(), this.getPort()).list();
            } else {
                LocateRegistry.getRegistry(this.getPort()).list();
            }
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static boolean hasSameAddress(String url) {
        if (singleton != null) {
            try {
                String host = ConfigurationUtil.getHostOfUrl(url);
                int port = ConfigurationUtil.getPortOfUrl(url);
                return (host.equals(singleton.getHost()) || InetAddress.getByName(host).equals(InetAddress.getByName(singleton.getHost()))) && port == singleton.getPort();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not a valid url: " + url, e);
            }
        }
        return false;
    }
}

