/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import java.io.File;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    final File file;
    final TYPE type;
    final String bsn;
    final String version;
    final String error;
    final Project project;
    final Map<String, String> attributes;

    Container(Project project, String bsn, String version, TYPE type, File source, String error, Map<String, String> attributes) {
        this.bsn = bsn;
        this.version = version;
        this.type = type;
        this.file = source != null ? source : new File("/" + bsn + ":" + version + ":" + (Object)((Object)type));
        this.project = project;
        this.error = error;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : attributes;
    }

    public Container(Project project, File file) {
        this(project, file.getName(), "project", TYPE.PROJECT, file, null, null);
    }

    public Container(File file) {
        this(null, file.getName(), "project", TYPE.EXTERNAL, file, null, null);
    }

    public File getFile() {
        return this.file;
    }

    public String getBundleSymbolicName() {
        return this.bsn;
    }

    public String getVersion() {
        return this.version;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (other instanceof Container) {
            return this.file.equals(((Container)other).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public Project getProject() {
        return this.project;
    }

    public String toString() {
        if (this.getError() != null) {
            return "/error/" + this.getError();
        }
        return this.getFile().getAbsolutePath();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        REPO,
        PROJECT,
        EXTERNAL,
        ERROR;

    }
}

