/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classpath;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.classpath.BndContainerInitializer;
import aQute.bnd.plugin.Central;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class BndContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private Table table;
    private Project model;
    private File basedir;
    private IJavaProject javaProject;

    public BndContainerPage() {
        super("bnd", "bnd - classpath", null);
        this.setDescription("Ensures that bnd sees the same classpath as eclipse. The table will show the current contents. If there is no bnd file, you can create it with the button");
        this.setPageComplete(true);
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
        this.model = Central.getCentral().getModel(project);
        this.basedir = project.getProject().getLocation().makeAbsolute().toFile();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.setControl((Control)composite);
        final Button wCreate = new Button(composite, 0);
        wCreate.setEnabled(this.model == null);
        FormData fd_wCreate = new FormData();
        fd_wCreate.bottom = new FormAttachment(100, -5);
        fd_wCreate.right = new FormAttachment(100, -4);
        wCreate.setLayoutData((Object)fd_wCreate);
        wCreate.setText("Create bnd.bnd");
        final TableViewer tableViewer = new TableViewer(composite, 2048);
        this.table = tableViewer.getTable();
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, 3);
        fd_table.left = new FormAttachment(0, 3);
        fd_table.right = new FormAttachment(100, -4);
        fd_table.bottom = new FormAttachment(100, -37);
        this.table.setLayoutData((Object)fd_table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn wBsn = new TableColumn(this.table, 0);
        wBsn.setWidth(200);
        wBsn.setText("Bundle Symbolic Name");
        TableColumn wVersion = new TableColumn(this.table, 0);
        wVersion.setWidth(100);
        wVersion.setText("Version");
        TableColumn wOptions = new TableColumn(this.table, 0);
        wOptions.setWidth(200);
        wOptions.setText("Options");
        TableColumn wFile = new TableColumn(this.table, 0);
        wFile.setWidth(100);
        wFile.setText("File");
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (BndContainerPage.this.model != null) {
                    try {
                        return BndContainerPage.this.model.getBuildpath().toArray();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                Container c = (Container)element;
                System.out.println(c);
                switch (columnIndex) {
                    case 0: {
                        return c.getBundleSymbolicName();
                    }
                    case 1: {
                        return c.getVersion();
                    }
                    case 2: {
                        return c.getError();
                    }
                    case 3: {
                        return c.getFile() + " (" + (c.getFile() != null && c.getFile().exists() ? "exists" : "?") + ")";
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        tableViewer.setInput((Object)this.model);
        wCreate.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println("defw selected");
            }

            public void widgetSelected(SelectionEvent e) {
                wCreate.setEnabled(!BndContainerPage.this.createBnd());
                tableViewer.setInput((Object)BndContainerPage.this.model);
            }
        });
    }

    protected boolean createBnd() {
        if (this.basedir != null && this.basedir.isDirectory()) {
            File bnd2 = new File(this.basedir, "bnd.bnd");
            try {
                FileOutputStream out = new FileOutputStream(bnd2);
                PrintStream ps = new PrintStream(out);
                try {
                    ps.println("# Auto generated by bnd, please adapt");
                    ps.println();
                    ps.println("Export-Package:                    ");
                    ps.println("Private-Package:                   ");
                    ps.println("Bundle-Name:                       ${Bundle-SymbolicName}");
                    ps.println("Bundle-Version:                    1.0");
                    ps.println();
                    ps.println("#Example buildpath");
                    ps.println("-buildpath:                        osgi;                                        version=4.0, \\");
                    ps.println("                                   com.springsource.junit;                      version=\"[3.8,4)\"");
                }
                finally {
                    out.close();
                    ps.close();
                }
                this.javaProject.getResource().refreshLocal(1, null);
                this.model = Central.getCentral().getModel(this.javaProject);
                return this.model != null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        Path containerPath = BndContainerInitializer.ID;
        IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)containerPath);
        return cpe;
    }

    public void setSelection(IClasspathEntry containerEntry) {
    }
}

