/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.registry;

import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;

public abstract class ConnectionFactory {
    public abstract Connection createConnection() throws JAXRException;

    public abstract FederatedConnection createFederatedConnection(Collection var1) throws JAXRException;

    public abstract Properties getProperties() throws JAXRException;

    public abstract void setProperties(Properties var1) throws JAXRException;

    public static ConnectionFactory newInstance() throws JAXRException {
        String className = System.getProperty("javax.xml.registry.ConnectionFactoryClass", "org.apache.ws.scout.registry.ConnectionFactoryImpl");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ConnectionFactory.class.getClassLoader();
        }
        try {
            Class<?> factoryClass = cl.loadClass(className);
            return (ConnectionFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JAXRException("Unable to load JAXR ConnectionFactoryClass: " + className, e);
        }
        catch (InstantiationException e) {
            throw new JAXRException("Unable to instantiate JAXR ConnectionFactoryClass: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new JAXRException("Unable to instantiate JAXR ConnectionFactoryClass: " + className, e);
        }
    }
}

