/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.publish.internal.registry;

import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.User;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.publish.AbsWSDLPublisher;
import org.ow2.jonas.ws.publish.PublicationInfo;
import org.ow2.jonas.ws.publish.PublishableDefinition;
import org.ow2.jonas.ws.publish.WSDLPublisher;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.w3c.dom.Element;

public class RegistryWSDLPublisher
extends AbsWSDLPublisher
implements WSDLPublisher {
    private static final String PUBLISH_URL_PROP = "javax.xml.registry.lifeCycleManagerURL";
    private static final String INQUIRY_URL_PROP = "javax.xml.registry.queryManagerURL";
    private static final String USERNAME = "jonas.service.publish.uddi.username";
    private static final String PASSWORD = "jonas.service.publish.uddi.password";
    private static final String ORGANIZATION_NAME = "jonas.service.publish.uddi.organization.name";
    private static final String ORGANIZATION_DESC = "jonas.service.publish.uddi.organization.desc";
    private static final String PERSON_NAME = "jonas.service.publish.uddi.organization.person_name";
    private ConnectionFactory connFactory;
    private PasswordAuthentication passAuth;
    private Properties props;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws.wsdl");
    private static I18n i18n = I18n.getInstance(RegistryWSDLPublisher.class);

    public RegistryWSDLPublisher(Properties props) throws WSDLPublisherException {
        this.props = props;
        String publishURL = props.getProperty(PUBLISH_URL_PROP);
        String queryURL = props.getProperty(INQUIRY_URL_PROP);
        String username = props.getProperty(USERNAME);
        String password = props.getProperty(PASSWORD);
        try {
            new URL(publishURL);
        }
        catch (MalformedURLException mue) {
            String err = i18n.getMessage("RegistryWSDLHandler.constr.mue", (Object)publishURL);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDLPublisherException(err, (Throwable)mue);
        }
        try {
            new URL(queryURL);
        }
        catch (MalformedURLException mue) {
            String err = i18n.getMessage("RegistryWSDLHandler.constr.mue", (Object)queryURL);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDLPublisherException(err, (Throwable)mue);
        }
        try {
            this.connFactory = ConnectionFactory.newInstance();
            this.connFactory.setProperties(props);
        }
        catch (JAXRException jaxre) {
            String err = i18n.getMessage("RegistryWSDLHandler.constr.jaxrException");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDLPublisherException(err, (Throwable)jaxre);
        }
        if (username == null || password == null) {
            String err = i18n.getMessage("RegistryWSDLHandler.constr.noCreds");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDLPublisherException(err);
        }
        this.passAuth = new PasswordAuthentication(username, password.toCharArray());
        String name = props.getProperty(ORGANIZATION_NAME);
        String person = props.getProperty(PERSON_NAME);
        if (name == null || person == null) {
            String err = i18n.getMessage("RegistryWSDLPublisher.constr.missingProp");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDLPublisherException(err);
        }
    }

    public void publish(PublishableDefinition publishableDefinition) throws WSDLPublisherException {
        Definition definition = publishableDefinition.getDefinition();
        PublicationInfo info = publishableDefinition.getPublicationInfo();
        try {
            Connection connection = this.connFactory.createConnection();
            HashSet<PasswordAuthentication> creds = new HashSet<PasswordAuthentication>();
            creds.add(this.passAuth);
            connection.setCredentials(creds);
            RegistryService rs = connection.getRegistryService();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            BusinessLifeCycleManager blcm = rs.getBusinessLifeCycleManager();
            InternationalString is = null;
            Organization org = blcm.createOrganization(this.props.getProperty(ORGANIZATION_NAME));
            String orgDesc = this.props.getProperty(ORGANIZATION_DESC);
            if (orgDesc != null) {
                is = blcm.createInternationalString(orgDesc);
                org.setDescription(is);
            }
            User contact = blcm.createUser();
            PersonName pName = blcm.createPersonName(this.props.getProperty(PERSON_NAME));
            contact.setPersonName(pName);
            org.setPrimaryContact(contact);
            ArrayList<Service> services = new ArrayList<Service>();
            for (javax.wsdl.Service s : definition.getServices().values()) {
                Service service = blcm.createService(s.getQName().getLocalPart());
                Element desc = s.getDocumentationElement();
                if (desc != null) {
                    String description = this.getDescription(desc);
                    is = blcm.createInternationalString(description);
                    service.setDescription(is);
                }
                ArrayList<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>();
                for (Port port : s.getPorts().values()) {
                    ServiceBinding binding = blcm.createServiceBinding();
                    Element pDesc = port.getDocumentationElement();
                    String pDescription = port.getName();
                    if (pDesc != null) {
                        pDescription = pDescription + " " + this.getDescription(pDesc);
                    }
                    is = blcm.createInternationalString(pDescription);
                    binding.setDescription(is);
                    binding.setValidateURI(false);
                    String url = this.getEndpoint(port);
                    binding.setAccessURI(url);
                    Concept concept = blcm.createConcept(null, port.getName() + " Concept", "");
                    is = blcm.createInternationalString(pDescription + " Concept");
                    concept.setDescription(is);
                    ExternalLink extlink = blcm.createExternalLink("file://", "WSDL");
                    extlink.setValidateURI(false);
                    extlink.setExternalURI(url + "?JWSDL");
                    concept.addExternalLink(extlink);
                    ClassificationScheme uddiOrgTypes = bqm.findClassificationSchemeByName(null, "uddi-org:types");
                    Classification wsdlSpecClass = blcm.createClassification(uddiOrgTypes, "wsdlSpec", "wsdlSpec");
                    concept.addClassification(wsdlSpecClass);
                    ArrayList<Concept> concepts = new ArrayList<Concept>();
                    concepts.add(concept);
                    BulkResponse br = blcm.saveConcepts(concepts);
                    String key = this.getKey(br);
                    String msg = i18n.getMessage("RegistryWSDLHandler.publish.conceptKey", (Object)port.getName(), (Object)key);
                    logger.log(BasicLevel.INFO, (Object)msg);
                    Concept c = (Concept)bqm.getRegistryObject(key, "Concept");
                    SpecificationLink specLink = blcm.createSpecificationLink();
                    specLink.setSpecificationObject((RegistryObject)c);
                    binding.addSpecificationLink(specLink);
                    serviceBindings.add(binding);
                }
                service.addServiceBindings(serviceBindings);
                services.add(service);
            }
            org.addServices(services);
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = blcm.saveOrganizations(orgs);
            String key = this.getKey(br);
            String msg = i18n.getMessage("RegistryWSDLPublisher.publish.organisationKey", (Object)org, (Object)key);
            logger.log(BasicLevel.INFO, (Object)msg);
        }
        catch (JAXRException jaxre) {
            String err = i18n.getMessage("RegistryWSDLHandler.publish.jaxrException");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDLPublisherException(err, (Throwable)jaxre);
        }
    }

    private String getEndpoint(Port port) {
        String url = null;
        List ee = port.getExtensibilityElements();
        for (ExtensibilityElement elem : ee) {
            if (!(elem instanceof SOAPAddress)) continue;
            SOAPAddress soap = (SOAPAddress)elem;
            url = soap.getLocationURI();
        }
        return url;
    }

    private String getDescription(Element e) {
        return e.getFirstChild().getNodeValue();
    }

    private String getKey(BulkResponse br) throws WSDLPublisherException, JAXRException {
        Iterator keyIter;
        String keyStr = null;
        Collection exceptions = br.getExceptions();
        Key key = null;
        if (exceptions == null) {
            Collection keys = br.getCollection();
            keyIter = keys.iterator();
            if (!keyIter.hasNext()) {
                String err = i18n.getMessage("RegistryWSDLHandler.getKey.noKeyReturned");
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new WSDLPublisherException(err);
            }
        } else {
            String err = i18n.getMessage("RegistryWSDLHandler.getKey.serverSideExceptions");
            Iterator exIter = exceptions.iterator();
            RegistryException cause = null;
            if (exIter.hasNext()) {
                cause = (RegistryException)exIter.next();
            }
            logger.log(BasicLevel.ERROR, (Object)err);
            if (cause == null) {
                throw new WSDLPublisherException(err);
            }
            throw new WSDLPublisherException(err, (Throwable)cause);
        }
        key = (Key)keyIter.next();
        keyStr = key.getId();
        return keyStr;
    }
}

