/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.EmptyQueueException;
import fr.dyade.aaa.util.StoppedQueueException;
import java.util.Vector;

public class Queue
extends Vector {
    private static final long serialVersionUID = 1L;
    private boolean stopping;

    public Queue() {
        this.start();
    }

    public synchronized void push(Object item) {
        if (this.stopping) {
            throw new StoppedQueueException();
        }
        this.addElement(item);
        this.notify();
    }

    public synchronized Object get() throws InterruptedException {
        while (this.size() == 0) {
            this.wait();
        }
        return this.elementAt(0);
    }

    public synchronized Object pop() {
        if (this.size() == 0) {
            throw new EmptyQueueException();
        }
        Object obj = this.elementAt(0);
        this.removeElementAt(0);
        if (this.stopping && this.size() == 0) {
            this.notify();
        }
        return obj;
    }

    public synchronized Object getAndPop() throws InterruptedException {
        while (this.size() == 0) {
            this.wait();
        }
        Object obj = this.elementAt(0);
        this.removeElementAt(0);
        if (this.stopping && this.size() == 0) {
            this.notify();
        }
        return obj;
    }

    public void start() {
        this.stopping = false;
    }

    public synchronized void stop() throws InterruptedException {
        this.stopping = true;
        if (this.size() != 0) {
            this.wait();
        }
    }
}

