/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXUtils {
    private static Log log = LogFactory.getLog(class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static boolean isFactoryPerClassLoader = true;
    private static XMLInputFactory inputFactory = null;
    private static XMLOutputFactory outputFactory = null;
    private static Map inputFactoryPerCL = Collections.synchronizedMap(new WeakHashMap());
    private static Map outputFactoryPerCL = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$apache$axiom$om$util$StAXUtils;

    public static XMLInputFactory getXMLInputFactory() {
        if (isFactoryPerClassLoader) {
            return StAXUtils.getXMLInputFactory_perClassLoader();
        }
        return StAXUtils.getXMLInputFactory_singleton();
    }

    public static XMLInputFactory getXMLInputFactory(boolean factoryPerClassLoaderPolicy) {
        if (factoryPerClassLoaderPolicy) {
            return StAXUtils.getXMLInputFactory_perClassLoader();
        }
        return StAXUtils.getXMLInputFactory_singleton();
    }

    public static void releaseXMLInputFactory(XMLInputFactory factory) {
    }

    public static XMLStreamReader createXMLStreamReader(final InputStream in, final String encoding) throws XMLStreamException {
        final XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = (XMLStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return inputFactory.createXMLStreamReader(in, encoding);
                }
            });
            if (isDebugEnabled) {
                log.debug("XMLStreamReader is " + reader.getClass().getName());
            }
            XMLStreamReader xMLStreamReader = reader;
            return xMLStreamReader;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    public static XMLStreamReader createXMLStreamReader(final InputStream in) throws XMLStreamException {
        final XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = (XMLStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return inputFactory.createXMLStreamReader(in);
                }
            });
            if (isDebugEnabled) {
                log.debug("XMLStreamReader is " + reader.getClass().getName());
            }
            XMLStreamReader xMLStreamReader = reader;
            return xMLStreamReader;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    public static XMLStreamReader createXMLStreamReader(final Reader in) throws XMLStreamException {
        final XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = (XMLStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return inputFactory.createXMLStreamReader(in);
                }
            });
            if (isDebugEnabled) {
                log.debug("XMLStreamReader is " + reader.getClass().getName());
            }
            XMLStreamReader xMLStreamReader = reader;
            return xMLStreamReader;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        if (isFactoryPerClassLoader) {
            return StAXUtils.getXMLOutputFactory_perClassLoader();
        }
        return StAXUtils.getXMLOutputFactory_singleton();
    }

    public static XMLOutputFactory getXMLOutputFactory(boolean factoryPerClassLoaderPolicy) {
        if (factoryPerClassLoaderPolicy) {
            return StAXUtils.getXMLOutputFactory_perClassLoader();
        }
        return StAXUtils.getXMLOutputFactory_singleton();
    }

    public static void setFactoryPerClassLoader(boolean value) {
        isFactoryPerClassLoader = value;
    }

    public static void releaseXMLOutputFactory(XMLOutputFactory factory) {
    }

    public static XMLStreamWriter createXMLStreamWriter(final OutputStream out) throws XMLStreamException {
        final XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = (XMLStreamWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return outputFactory.createXMLStreamWriter(out, "utf-8");
                }
            });
            if (isDebugEnabled) {
                log.debug("XMLStreamWriter is " + writer.getClass().getName());
            }
            return writer;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(final OutputStream out, final String encoding) throws XMLStreamException {
        final XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = (XMLStreamWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return outputFactory.createXMLStreamWriter(out, encoding);
                }
            });
            if (isDebugEnabled) {
                log.debug("XMLStreamWriter is " + writer.getClass().getName());
            }
            return writer;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(final Writer out) throws XMLStreamException {
        final XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = (XMLStreamWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return outputFactory.createXMLStreamWriter(out);
                }
            });
            if (isDebugEnabled) {
                log.debug("XMLStreamWriter is " + writer.getClass().getName());
            }
            return writer;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static void reset() {
    }

    private static XMLInputFactory getXMLInputFactory_perClassLoader() {
        XMLInputFactory factory;
        ClassLoader cl = StAXUtils.getContextClassLoader();
        if (cl == null) {
            factory = StAXUtils.getXMLInputFactory_singleton();
        } else {
            factory = (XMLInputFactory)inputFactoryPerCL.get(cl);
            if (factory == null) {
                factory = (XMLInputFactory)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return XMLInputFactory.newInstance();
                    }
                });
                if (factory != null) {
                    inputFactoryPerCL.put(cl, factory);
                    if (log.isDebugEnabled()) {
                        log.debug("Created XMLInputFactory = " + factory.getClass() + " for classloader=" + cl);
                        log.debug("Size of XMLInputFactory map =" + inputFactoryPerCL.size());
                    }
                } else {
                    factory = StAXUtils.getXMLInputFactory_singleton();
                }
            }
        }
        return factory;
    }

    private static XMLInputFactory getXMLInputFactory_singleton() {
        if (inputFactory == null) {
            inputFactory = (XMLInputFactory)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader savedClassLoader = currentThread.getContextClassLoader();
                    XMLInputFactory factory = null;
                    try {
                        currentThread.setContextClassLoader((class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils).getClassLoader());
                        factory = XMLInputFactory.newInstance();
                    }
                    finally {
                        currentThread.setContextClassLoader(savedClassLoader);
                    }
                    return factory;
                }
            });
            if (log.isDebugEnabled() && inputFactory != null) {
                log.debug("Created singleton XMLInputFactory = " + inputFactory.getClass());
            }
        }
        return inputFactory;
    }

    public static XMLOutputFactory getXMLOutputFactory_perClassLoader() {
        XMLOutputFactory factory;
        ClassLoader cl = StAXUtils.getContextClassLoader();
        if (cl == null) {
            factory = StAXUtils.getXMLOutputFactory_singleton();
        } else {
            factory = (XMLOutputFactory)outputFactoryPerCL.get(cl);
            if (factory == null) {
                factory = (XMLOutputFactory)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        XMLOutputFactory factory = XMLOutputFactory.newInstance();
                        factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
                        return factory;
                    }
                });
                if (factory != null) {
                    outputFactoryPerCL.put(cl, factory);
                    if (log.isDebugEnabled()) {
                        log.debug("Created XMLOutputFactory = " + factory.getClass() + " for classloader=" + cl);
                        log.debug("Size of XMLOutputFactory map =" + outputFactoryPerCL.size());
                    }
                } else {
                    factory = StAXUtils.getXMLOutputFactory_singleton();
                }
            }
        }
        return factory;
    }

    public static XMLOutputFactory getXMLOutputFactory_singleton() {
        if (outputFactory == null) {
            outputFactory = (XMLOutputFactory)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader savedClassLoader = currentThread.getContextClassLoader();
                    XMLOutputFactory factory = null;
                    try {
                        currentThread.setContextClassLoader((class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils).getClassLoader());
                        factory = XMLOutputFactory.newInstance();
                        factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
                    }
                    finally {
                        currentThread.setContextClassLoader(savedClassLoader);
                    }
                    return factory;
                }
            });
            if (log.isDebugEnabled() && outputFactory != null) {
                log.debug("Created singleton XMLOutputFactory = " + outputFactory.getClass());
            }
        }
        return outputFactory;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

