/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.builder;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.exception.OMBuilderException;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.SOAPBuilderHelper;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.w3c.dom.Element;

public class SOAP11BuilderHelper
extends SOAPBuilderHelper
implements SOAP11Constants {
    private SOAPFactory factory;
    private boolean faultcodePresent = false;
    private boolean faultstringPresent = false;

    public SOAP11BuilderHelper(StAXSOAPModelBuilder builder) {
        super(builder);
        this.factory = builder.getSoapFactory();
    }

    public OMElement handleEvent(XMLStreamReader parser2, OMElement parent, int elementLevel) throws SOAPProcessingException {
        this.parser = parser2;
        OMElement element = null;
        String localName = parser2.getLocalName();
        if (elementLevel == 4) {
            if ("faultcode".equals(localName)) {
                SOAPFaultCode code = this.factory.createSOAPFaultCode((SOAPFault)parent, this.builder);
                this.processNamespaceData(code, false);
                this.processAttributes(code);
                this.processText(parser2, code);
                ((OMNodeEx)((Object)code)).setComplete(true);
                element = code;
                this.builder.adjustElementLevel(-1);
                this.faultcodePresent = true;
            } else if ("faultstring".equals(localName)) {
                SOAPFaultReason reason = this.factory.createSOAPFaultReason((SOAPFault)parent, this.builder);
                this.processNamespaceData(reason, false);
                this.processAttributes(reason);
                this.processText(parser2, reason);
                ((OMNodeEx)((Object)reason)).setComplete(true);
                element = reason;
                this.builder.adjustElementLevel(-1);
                this.faultstringPresent = true;
            } else if ("faultactor".equals(localName)) {
                element = this.factory.createSOAPFaultRole((SOAPFault)parent, this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            } else if ("detail".equals(localName)) {
                element = this.factory.createSOAPFaultDetail((SOAPFault)parent, this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            } else {
                element = this.factory.createOMElement(localName, null, parent, this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            }
        } else if (elementLevel == 5) {
            String parentTagName = "";
            parentTagName = parent instanceof Element ? ((Element)((Object)parent)).getTagName() : parent.getLocalName();
            if (parentTagName.equals("faultcode")) {
                throw new OMBuilderException("faultcode element should not have children");
            }
            if (parentTagName.equals("faultstring")) {
                throw new OMBuilderException("faultstring element should not have children");
            }
            if (parentTagName.equals("faultactor")) {
                throw new OMBuilderException("faultactor element should not have children");
            }
            element = this.factory.createOMElement(localName, null, parent, this.builder);
            this.processNamespaceData(element, false);
            this.processAttributes(element);
        } else if (elementLevel > 5) {
            element = this.factory.createOMElement(localName, null, parent, this.builder);
            this.processNamespaceData(element, false);
            this.processAttributes(element);
        }
        return element;
    }

    private void processText(XMLStreamReader parser2, OMElement value) {
        try {
            int token = parser2.next();
            while (token != 2) {
                if (token != 4) {
                    throw new SOAPProcessingException("Only Characters are allowed here");
                }
                this.factory.createOMText((OMContainer)value, parser2.getText());
                token = parser2.next();
            }
        }
        catch (XMLStreamException e) {
            throw new SOAPProcessingException(e);
        }
    }
}

