/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.AttributeExtensible;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;

public abstract class AddressingUtils {
    private static final Set ADDRESSING_NS_URI_SET = new HashSet();

    public static void removeHeader(SOAPHeader soapHeader, String actorURI, String headerName) {
        if (soapHeader == null) {
            return;
        }
        Iterator headers = soapHeader.examineHeaderElements(actorURI);
        ArrayList<SOAPHeaderElement> existingElements = new ArrayList<SOAPHeaderElement>();
        while (headers.hasNext()) {
            SOAPHeaderElement hElement = (SOAPHeaderElement)headers.next();
            Name hName = hElement.getElementName();
            if (!AddressingUtils.isAddressingNamespaceURI(hName.getURI()) || !hName.getLocalName().equals(headerName)) continue;
            existingElements.add(hElement);
        }
        for (int i = 0; i < existingElements.size(); ++i) {
            SOAPHeaderElement el = (SOAPHeaderElement)existingElements.get(i);
            el.detachNode();
        }
    }

    public static boolean isAddressingNamespaceURI(String uri) {
        return ADDRESSING_NS_URI_SET.contains(uri);
    }

    public static void removeHeaders(SOAPHeader soapHeader, String actorURI) {
        if (soapHeader == null) {
            return;
        }
        Iterator headers = soapHeader.examineHeaderElements(actorURI);
        ArrayList<SOAPHeaderElement> existingElements = new ArrayList<SOAPHeaderElement>();
        while (headers.hasNext()) {
            SOAPHeaderElement hElement = (SOAPHeaderElement)headers.next();
            Name hName = hElement.getElementName();
            if (!AddressingUtils.isAddressingNamespaceURI(hName.getURI())) continue;
            existingElements.add(hElement);
        }
        for (int i = 0; i < existingElements.size(); ++i) {
            SOAPHeaderElement el = (SOAPHeaderElement)existingElements.get(i);
            el.detachNode();
        }
    }

    public static AddressingHeaders getResponseHeaders(javax.xml.rpc.handler.MessageContext msgCtx) {
        return AddressingUtils.getHeaders(msgCtx, "org.apache.axis.message.addressing.RESPONSE.HEADERS");
    }

    public static AddressingHeaders getRequestHeaders(javax.xml.rpc.handler.MessageContext msgCtx) {
        return AddressingUtils.getHeaders(msgCtx, "org.apache.axis.message.addressing.REQUEST.HEADERS");
    }

    public static String getInputAction(QName portTypeQName, Operation operation) {
        if (portTypeQName == null || operation == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Input input = operation.getInput();
        if (input == null) {
            return null;
        }
        return AddressingUtils.getAction(input, input.getName(), portTypeQName, operation, "Request");
    }

    public static String getOutputAction(QName portTypeQName, Operation operation) {
        if (portTypeQName == null || operation == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Output output = operation.getOutput();
        if (output == null) {
            return null;
        }
        return AddressingUtils.getAction(output, output.getName(), portTypeQName, operation, "Response");
    }

    public static String getNamespacePrefix(SOAPElement element, String namespace) throws SOAPException {
        if (element == null || namespace == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Iterator iter = element.getVisibleNamespacePrefixes();
        String prefix = null;
        String ns = null;
        while (iter.hasNext()) {
            prefix = (String)iter.next();
            ns = element.getNamespaceURI(prefix);
            if (!namespace.equals(ns)) continue;
            return prefix;
        }
        int i = 0;
        prefix = "ns" + i;
        while (element.getNamespaceURI(prefix) != null) {
            prefix = "ns" + i++;
        }
        element.addNamespaceDeclaration(prefix, namespace);
        return prefix;
    }

    public static String getAddressingNamespaceURI() {
        String nsURI = null;
        MessageContext msgContext = AxisEngine.getCurrentMessageContext();
        if (msgContext != null) {
            nsURI = (String)msgContext.getProperty("addressing.namespace.URI");
        }
        if (nsURI == null) {
            nsURI = System.getProperty("addressing.namespace.URI");
        }
        if (nsURI == null) {
            nsURI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        }
        return nsURI;
    }

    public static String getFaultActionURI() {
        return AddressingUtils.getAddressingNamespaceURI() + "/fault";
    }

    public static String getAnonymousRoleURI() {
        return AddressingUtils.getAddressingNamespaceURI() + "/role/anonymous";
    }

    public static QName getResponseRelationshipType() {
        String nsURI = AddressingUtils.getAddressingNamespaceURI();
        if (nsURI.equals("http://schemas.xmlsoap.org/ws/2003/03/addressing")) {
            return new QName(nsURI, "Response");
        }
        return new QName(nsURI, "Reply");
    }

    private static AddressingHeaders getHeaders(javax.xml.rpc.handler.MessageContext msgContext, String type) {
        AddressingHeaders headers = (AddressingHeaders)msgContext.getProperty(type);
        if (headers == null) {
            headers = new AddressingHeaders();
            msgContext.setProperty(type, headers);
        }
        return headers;
    }

    private static String getAction(AttributeExtensible inputOutput, String inputOutputName, QName portTypeQName, Operation operation, String defaultName) {
        Object value = inputOutput.getExtensionAttribute(new QName(AddressingUtils.getAddressingNamespaceURI(), "Action"));
        if (value != null) {
            if (value instanceof QName) {
                return ((QName)value).getLocalPart();
            }
            return value.toString();
        }
        String name = inputOutputName;
        if (name == null) {
            name = operation.getName() + defaultName;
        }
        StringBuffer buf = new StringBuffer(50);
        buf.append(portTypeQName.getNamespaceURI());
        if (!portTypeQName.getNamespaceURI().endsWith("/")) {
            buf.append("/");
        }
        buf.append(portTypeQName.getLocalPart()).append("/").append(name);
        return buf.toString();
    }

    static {
        ADDRESSING_NS_URI_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing");
        ADDRESSING_NS_URI_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing");
        ADDRESSING_NS_URI_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
    }
}

