/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaConstants;
import org.apache.cxf.javascript.ItemInfo;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.cxf.javascript.XmlSchemaUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;

public final class AttributeInfo
implements ItemInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(AttributeInfo.class);
    private XmlSchemaAnnotated annotated;
    private String javascriptName;
    private String xmlName;
    private XmlSchemaType containingType;
    private XmlSchemaType type;
    private boolean any;
    private boolean anyType;
    private String defaultValue;
    private String fixedValue;
    private boolean global;
    private XmlSchemaUse use;

    private AttributeInfo() {
    }

    public static AttributeInfo forGlobalAttribute(XmlSchemaAttribute attribute, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator) {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.annotated = attribute;
        attributeInfo.global = true;
        AttributeInfo.factoryCommon(attribute, currentSchema, schemaCollection, prefixAccumulator, attributeInfo);
        return attributeInfo;
    }

    public static AttributeInfo forLocalItem(XmlSchemaObject sequenceObject, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, QName contextName) {
        XmlSchemaAnnotated annotated = XmlSchemaUtils.getObjectAnnotated(sequenceObject, contextName);
        AttributeInfo attributeInfo = new AttributeInfo();
        XmlSchemaAnnotated realAnnotated = annotated;
        if (annotated instanceof XmlSchemaAttribute) {
            XmlSchemaAttribute attribute = (XmlSchemaAttribute)annotated;
            attributeInfo.use = attribute.getUse();
            if (attribute.getRefName() != null) {
                XmlSchemaAttribute refAttribute = schemaCollection.getAttributeByQName(attribute.getRefName());
                if (refAttribute == null) {
                    throw new UnsupportedConstruct(LOG, "ATTRIBUTE_DANGLING_REFERENCE", attribute.getQName(), attribute.getRefName());
                }
                realAnnotated = refAttribute;
                attributeInfo.global = true;
            }
        } else if (annotated instanceof XmlSchemaAnyAttribute) {
            attributeInfo.any = true;
            attributeInfo.xmlName = null;
            attributeInfo.javascriptName = "any";
            attributeInfo.type = null;
            attributeInfo.use = new XmlSchemaUse("optional");
        } else {
            throw new UnsupportedConstruct(LOG, "UNSUPPORTED_ATTRIBUTE_ITEM", annotated, contextName);
        }
        AttributeInfo.factoryCommon(realAnnotated, currentSchema, schemaCollection, prefixAccumulator, attributeInfo);
        attributeInfo.annotated = realAnnotated;
        return attributeInfo;
    }

    private static void factoryCommon(XmlSchemaAnnotated annotated, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, AttributeInfo attributeInfo) {
        if (annotated instanceof XmlSchemaAttribute) {
            XmlSchemaAttribute attribute = (XmlSchemaAttribute)annotated;
            String attributeNamespaceURI = attribute.getQName().getNamespaceURI();
            boolean attributeNoNamespace = "".equals(attributeNamespaceURI);
            XmlSchema attributeSchema = null;
            if (!attributeNoNamespace && (attributeSchema = schemaCollection.getSchemaByTargetNamespace(attributeNamespaceURI)) == null) {
                throw new RuntimeException("Missing schema " + attributeNamespaceURI);
            }
            boolean qualified = !attributeNoNamespace && XmlSchemaUtils.isAttributeQualified(attribute, true, currentSchema, attributeSchema);
            attributeInfo.xmlName = prefixAccumulator.xmlAttributeString(attribute, qualified);
            attributeInfo.javascriptName = attribute.getQName().getLocalPart();
            attributeInfo.defaultValue = attribute.getDefaultValue();
            attributeInfo.fixedValue = attribute.getFixedValue();
            attributeInfo.use = attribute.getUse();
            AttributeInfo.factorySetupType(attribute, schemaCollection, attributeInfo);
        } else {
            attributeInfo.any = true;
            attributeInfo.xmlName = null;
            attributeInfo.javascriptName = "any";
            attributeInfo.type = null;
            attributeInfo.use = new XmlSchemaUse("optional");
        }
    }

    private static void factorySetupType(XmlSchemaAttribute element, SchemaCollection schemaCollection, AttributeInfo attributeInfo) {
        attributeInfo.type = element.getSchemaType();
        if (attributeInfo.type == null) {
            if (element.getSchemaTypeName().equals(XmlSchemaConstants.ANY_TYPE_QNAME)) {
                attributeInfo.anyType = true;
            } else {
                attributeInfo.type = schemaCollection.getTypeByQName(element.getSchemaTypeName());
                if (attributeInfo.type == null && !element.getSchemaTypeName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    XmlSchemaUtils.unsupportedConstruct("MISSING_TYPE", element.getSchemaTypeName().toString(), element.getQName(), element);
                }
            }
        } else if (attributeInfo.type.getQName() != null && XmlSchemaConstants.ANY_TYPE_QNAME.equals(attributeInfo.type.getQName())) {
            attributeInfo.anyType = true;
        }
    }

    public XmlSchemaAnnotated getAnnotated() {
        return this.annotated;
    }

    public String getJavascriptName() {
        return this.javascriptName;
    }

    public void setJavascriptName(String name) {
        this.javascriptName = name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String elementXmlName) {
        this.xmlName = elementXmlName;
    }

    public XmlSchemaType getContainingType() {
        return this.containingType;
    }

    public void setContainingType(XmlSchemaType containingType) {
        this.containingType = containingType;
    }

    public XmlSchemaType getType() {
        return this.type;
    }

    public void setType(XmlSchemaType type) {
        this.type = type;
    }

    public boolean isAny() {
        return this.any;
    }

    public boolean isAnyType() {
        return this.anyType;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null && this.fixedValue != null) {
            return this.fixedValue;
        }
        return this.defaultValue;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNillable() {
        return false;
    }

    public boolean isOptional() {
        return !this.use.equals(new XmlSchemaUse("required"));
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }
}

