/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaConstants;
import org.apache.cxf.javascript.ItemInfo;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.cxf.javascript.XmlSchemaUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaType;

public final class ParticleInfo
implements ItemInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(ParticleInfo.class);
    private XmlSchemaParticle particle;
    private String javascriptName;
    private String xmlName;
    private XmlSchemaType containingType;
    private XmlSchemaType type;
    private boolean empty;
    private long minOccurs;
    private long maxOccurs;
    private boolean nillable;
    private boolean any;
    private boolean anyType;
    private String defaultValue;
    private boolean global;

    private ParticleInfo() {
    }

    public static ParticleInfo forGlobalElement(XmlSchemaElement element, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator) {
        ParticleInfo elementInfo = new ParticleInfo();
        elementInfo.particle = element;
        elementInfo.minOccurs = element.getMinOccurs();
        elementInfo.maxOccurs = element.getMaxOccurs();
        elementInfo.nillable = element.isNillable();
        elementInfo.global = true;
        ParticleInfo.factoryCommon(element, currentSchema, schemaCollection, prefixAccumulator, elementInfo);
        return elementInfo;
    }

    public static ParticleInfo forPartElement(XmlSchemaElement element, SchemaCollection schemaCollection, String javascriptName, String xmlElementName) {
        ParticleInfo elementInfo = new ParticleInfo();
        elementInfo.particle = element;
        if (element == null) {
            elementInfo.minOccurs = 1L;
            elementInfo.maxOccurs = 1L;
        } else {
            elementInfo.minOccurs = element.getMinOccurs();
            elementInfo.maxOccurs = element.getMaxOccurs();
            elementInfo.nillable = element.isNillable();
            ParticleInfo.factorySetupType(element, schemaCollection, elementInfo);
        }
        elementInfo.javascriptName = javascriptName;
        elementInfo.xmlName = xmlElementName;
        elementInfo.global = true;
        return elementInfo;
    }

    public static ParticleInfo forLocalItem(XmlSchemaObject sequenceObject, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, QName contextName) {
        XmlSchemaParticle sequenceParticle = XmlSchemaUtils.getObjectParticle(sequenceObject, contextName);
        ParticleInfo elementInfo = new ParticleInfo();
        XmlSchemaParticle realParticle = sequenceParticle;
        if (sequenceParticle instanceof XmlSchemaElement) {
            XmlSchemaElement sequenceElement = (XmlSchemaElement)sequenceParticle;
            if (sequenceElement.getRefName() != null) {
                XmlSchemaElement refElement = schemaCollection.getElementByQName(sequenceElement.getRefName());
                if (refElement == null) {
                    Message message = new Message("ELEMENT_DANGLING_REFERENCE", LOG, sequenceElement.getQName(), sequenceElement.getRefName());
                    throw new UnsupportedConstruct(message.toString());
                }
                realParticle = refElement;
                elementInfo.global = true;
            }
            elementInfo.nillable = ((XmlSchemaElement)realParticle).isNillable();
        }
        elementInfo.minOccurs = sequenceParticle.getMinOccurs();
        elementInfo.maxOccurs = sequenceParticle.getMaxOccurs();
        ParticleInfo.factoryCommon(realParticle, currentSchema, schemaCollection, prefixAccumulator, elementInfo);
        elementInfo.particle = realParticle;
        return elementInfo;
    }

    private static void factoryCommon(XmlSchemaParticle particle, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, ParticleInfo elementInfo) {
        if (particle instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)particle;
            String elementNamespaceURI = element.getQName().getNamespaceURI();
            boolean elementNoNamespace = "".equals(elementNamespaceURI);
            XmlSchema elementSchema = null;
            if (!elementNoNamespace && (elementSchema = schemaCollection.getSchemaByTargetNamespace(elementNamespaceURI)) == null) {
                throw new RuntimeException("Missing schema " + elementNamespaceURI);
            }
            boolean qualified = !elementNoNamespace && XmlSchemaUtils.isElementQualified(element, true, currentSchema, elementSchema);
            elementInfo.xmlName = prefixAccumulator.xmlElementString(element, qualified);
            elementInfo.javascriptName = element.getQName().getLocalPart();
            elementInfo.defaultValue = element.getDefaultValue();
            ParticleInfo.factorySetupType(element, schemaCollection, elementInfo);
        } else {
            elementInfo.any = true;
            elementInfo.xmlName = null;
            elementInfo.javascriptName = "any";
            elementInfo.type = null;
        }
    }

    private static void factorySetupType(XmlSchemaElement element, SchemaCollection schemaCollection, ParticleInfo elementInfo) {
        elementInfo.type = element.getSchemaType();
        if (elementInfo.type == null) {
            if (element.getSchemaTypeName().equals(XmlSchemaConstants.ANY_TYPE_QNAME)) {
                elementInfo.anyType = true;
            } else {
                elementInfo.type = schemaCollection.getTypeByQName(element.getSchemaTypeName());
                if (elementInfo.type == null && !element.getSchemaTypeName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    XmlSchemaUtils.unsupportedConstruct("MISSING_TYPE", element.getSchemaTypeName().toString(), element.getQName(), element);
                }
            }
        } else if (elementInfo.type.getQName() != null && XmlSchemaConstants.ANY_TYPE_QNAME.equals(elementInfo.type.getQName())) {
            elementInfo.anyType = true;
        }
    }

    public QName getControllingName() {
        XmlSchemaElement element;
        if (this.type != null && this.type.getQName() != null) {
            return this.type.getQName();
        }
        if (this.particle instanceof XmlSchemaElement && (element = (XmlSchemaElement)this.particle).getQName() != null) {
            return element.getQName();
        }
        Message message = new Message("IMPOSSIBLE_GLOBAL_ITEM", LOG, XmlSchemaUtils.cleanedUpSchemaSource(this.particle));
        LOG.severe(message.toString());
        throw new UnsupportedConstruct(message);
    }

    public XmlSchemaParticle getParticle() {
        return this.particle;
    }

    public String getJavascriptName() {
        return this.javascriptName;
    }

    public void setJavascriptName(String name) {
        this.javascriptName = name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String elementXmlName) {
        this.xmlName = elementXmlName;
    }

    public XmlSchemaType getContainingType() {
        return this.containingType;
    }

    public void setContainingType(XmlSchemaType containingType) {
        this.containingType = containingType;
    }

    public XmlSchemaType getType() {
        return this.type;
    }

    public void setType(XmlSchemaType type) {
        this.type = type;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public long getMinOccurs() {
        return this.minOccurs;
    }

    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean isArray() {
        return this.maxOccurs > 1L;
    }

    public boolean isOptional() {
        return this.minOccurs == 0L && this.maxOccurs == 1L;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isAny() {
        return this.any;
    }

    public boolean isAnyType() {
        return this.anyType;
    }

    public String getDefaultValue() {
        if (this.isOptional()) {
            return "null";
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isGlobal() {
        return this.global;
    }
}

