/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchAsyncCallable<T>
implements Callable<T> {
    private Dispatch<T> dispatch;
    private T object;
    private AsyncHandler callback;

    public DispatchAsyncCallable(Dispatch<T> disp, T obj, AsyncHandler c) {
        this.dispatch = disp;
        this.object = obj;
        this.callback = c;
    }

    @Override
    public T call() throws Exception {
        final T result = this.dispatch.invoke(this.object);
        if (this.callback != null) {
            this.callback.handleResponse(new Response<Object>(){

                @Override
                public Map<String, Object> getContext() {
                    return DispatchAsyncCallable.this.dispatch.getResponseContext();
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public Object get() {
                    return result;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public Object get(long timeout, TimeUnit unit) {
                    return result;
                }
            });
        }
        return result;
    }
}

