/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingType;
import javax.xml.ws.FaultAction;
import javax.xml.ws.Service;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JAXWSMethodDispatcher;
import org.apache.cxf.jaxws.JAXWSProviderMethodDispatcher;
import org.apache.cxf.jaxws.WrapperClassGenerator;
import org.apache.cxf.jaxws.interceptors.DispatchInDatabindingInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchOutDatabindingInterceptor;
import org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.jaxws.support.WebServiceProviderConfiguration;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServiceFactoryBean
extends ReflectionServiceFactoryBean {
    public static final String WS_FEATURES = "JAXWS-WS-FEATURES";
    private static final Logger LOG = LogUtils.getLogger(JaxWsServiceFactoryBean.class);
    private AbstractServiceConfiguration jaxWsConfiguration;
    private JaxWsImplementorInfo implInfo;
    private List<WebServiceFeature> wsFeatures;
    private boolean wrapperBeanGenerated;
    private Set<Class<?>> wrapperClasses;

    public JaxWsServiceFactoryBean() {
        this.getIgnoredClasses().add(Service.class.getName());
        this.setQualifyWrapperSchema(false);
        this.initSchemaLocations();
    }

    public JaxWsServiceFactoryBean(JaxWsImplementorInfo implInfo) {
        this();
        this.implInfo = implInfo;
        this.initConfiguration(implInfo);
        this.serviceClass = implInfo.getEndpointClass();
        this.loadWSFeatureAnnotation(implInfo.getSEIClass(), implInfo.getImplementorClass());
    }

    private void initSchemaLocations() {
        this.schemaLocationMapping.put("http://www.w3.org/2005/08/addressing", "http://www.w3.org/2006/03/addressing/ws-addr.xsd");
    }

    private void loadWSFeatureAnnotation(Class<?> serviceClass, Class<?> implementorClass) {
        ArrayList<WebServiceFeature> features = new ArrayList<WebServiceFeature>();
        MTOM mtom = this.implInfo.getImplementorClass().getAnnotation(MTOM.class);
        if (mtom == null && serviceClass != null) {
            mtom = serviceClass.getAnnotation(MTOM.class);
        }
        if (mtom != null) {
            features.add(new MTOMFeature(mtom.enabled(), mtom.threshold()));
        } else {
            BindingType bt = this.implInfo.getImplementorClass().getAnnotation(BindingType.class);
            if (bt != null && ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bt.value()) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bt.value()))) {
                features.add(new MTOMFeature(true));
            }
        }
        Addressing addressing = null;
        if (implementorClass != null) {
            addressing = implementorClass.getAnnotation(Addressing.class);
        }
        if (addressing == null && serviceClass != null) {
            addressing = serviceClass.getAnnotation(Addressing.class);
        }
        if (addressing != null) {
            features.add(new AddressingFeature(addressing.enabled(), addressing.required()));
        }
        if (features.size() > 0) {
            this.wsFeatures = features;
        }
    }

    @Override
    public org.apache.cxf.service.Service create() {
        org.apache.cxf.service.Service s = super.create();
        s.put("endpoint.class", this.implInfo.getEndpointClass());
        return s;
    }

    @Override
    public void setServiceClass(Class<?> serviceClass) {
        this.setJaxWsImplementorInfo(new JaxWsImplementorInfo(serviceClass));
        super.setServiceClass(this.getJaxWsImplementorInfo().getEndpointClass());
    }

    @Override
    protected void checkServiceClassAnnotations(Class<?> sc) {
    }

    @Override
    protected void initializeDefaultInterceptors() {
        super.initializeDefaultInterceptors();
        if (this.implInfo.isWebServiceProvider()) {
            Class<?> type = this.implInfo.getProviderParameterType();
            Service.Mode mode = this.implInfo.getServiceMode();
            this.getService().getInInterceptors().add(new DispatchInDatabindingInterceptor(type, mode));
            this.getService().getOutInterceptors().add(new DispatchOutDatabindingInterceptor(mode));
        }
    }

    @Override
    protected void initializeFaultInterceptors() {
        this.getService().getOutFaultInterceptors().add(new WebFaultOutInterceptor());
    }

    @Override
    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new JaxWsEndpointImpl(this.getBus(), this.getService(), ei, this.implInfo, this.wsFeatures, this.getFeatures(), this.isFromWsdl());
    }

    @Override
    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method method) {
        method = ((JaxWsServiceConfiguration)this.jaxWsConfiguration).getDeclaredMethod(method);
        o.setProperty(Method.class.getName(), method);
        o.setProperty("operation.method", method);
        this.initializeWrapping(o, method);
        this.bindOperation(o, method);
        Operation op = (Operation)o.getProperty(WSDLServiceBuilder.WSDL_OPERATION);
        this.initializeClassInfo(o, method, op == null ? null : CastUtils.cast(op.getParameterOrdering(), String.class));
    }

    @Override
    protected void bindOperation(OperationInfo op, Method method) {
        try {
            Method responseMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", method.getParameterTypes());
            List<Class<?>> asyncHandlerParams = Arrays.asList(method.getParameterTypes());
            asyncHandlerParams = new ArrayList(asyncHandlerParams);
            asyncHandlerParams.add(AsyncHandler.class);
            Method futureMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", asyncHandlerParams.toArray(new Class[asyncHandlerParams.size()]));
            this.getMethodDispatcher().bind(op, method, responseMethod, futureMethod);
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException(e);
        }
        catch (NoSuchMethodException e) {
            this.getMethodDispatcher().bind(op, method);
        }
    }

    @Override
    protected void initializeWSDLOperations() {
        if (this.implInfo.isWebServiceProvider()) {
            this.initializeWSDLOperationsForProvider();
        } else {
            super.initializeWSDLOperations();
        }
    }

    protected void initializeWSDLOperationsForProvider() {
        Type[] genericInterfaces = this.getServiceClass().getGenericInterfaces();
        ParameterizedType pt = (ParameterizedType)genericInterfaces[0];
        Class c = (Class)pt.getActualTypeArguments()[0];
        if (this.getEndpointInfo() == null && this.isFromWsdl()) {
            ArrayList<QName> enames = new ArrayList<QName>();
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (EndpointInfo ep : si.getEndpoints()) {
                    enames.add(ep.getName());
                }
            }
            LOG.log(Level.WARNING, "COULD_NOT_FIND_ENDPOINT", new Object[]{this.getEndpointName(), enames});
        }
        try {
            Method invoke = this.getServiceClass().getMethod("invoke", c);
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (OperationInfo o : si.getInterface().getOperations()) {
                    this.getMethodDispatcher().bind(o, invoke);
                }
                for (BindingInfo bi : si.getBindings()) {
                    bi.setProperty("databinding.disabled", Boolean.TRUE);
                }
            }
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceConstructionException(e);
        }
    }

    void initializeWrapping(OperationInfo o, Method selected) {
        Class requestWrapper;
        Class responseWrapper = this.getResponseWrapper(selected);
        if (responseWrapper != null) {
            o.getOutput().getMessageParts().get(0).setTypeClass(responseWrapper);
        }
        if (this.getResponseWrapperClassName(selected) != null) {
            o.getOutput().getMessageParts().get(0).setProperty("RESPONSE.WRAPPER.CLASSNAME", this.getResponseWrapperClassName(selected));
        }
        if ((requestWrapper = this.getRequestWrapper(selected)) != null) {
            o.getInput().getMessageParts().get(0).setTypeClass(requestWrapper);
        }
        if (this.getRequestWrapperClassName(selected) != null) {
            o.getInput().getMessageParts().get(0).setProperty("REQUEST.WRAPPER.CLASSNAME", this.getRequestWrapperClassName(selected));
        }
    }

    @Override
    protected Class<?> getBeanClass(Class<?> exClass) {
        try {
            if (ServerException.class.isAssignableFrom(exClass) || RemoteException.class.isAssignableFrom(exClass) || "javax.xml.ws".equals(PackageUtils.getPackageName(exClass))) {
                return null;
            }
            Method getFaultInfo = exClass.getMethod("getFaultInfo", new Class[0]);
            return getFaultInfo.getReturnType();
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException(e);
        }
        catch (NoSuchMethodException e) {
            WebFault fault = exClass.getAnnotation(WebFault.class);
            if (fault != null && !StringUtils.isEmpty(fault.faultBean())) {
                try {
                    return ClassLoaderUtils.loadClass(fault.faultBean(), exClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.getBeanClass(exClass);
        }
    }

    public void setJaxWsConfiguration(JaxWsServiceConfiguration jaxWsConfiguration) {
        this.jaxWsConfiguration = jaxWsConfiguration;
    }

    public JaxWsImplementorInfo getJaxWsImplementorInfo() {
        return this.implInfo;
    }

    public void setJaxWsImplementorInfo(JaxWsImplementorInfo jaxWsImplementorInfo) {
        this.implInfo = jaxWsImplementorInfo;
        this.initConfiguration(jaxWsImplementorInfo);
    }

    protected final void initConfiguration(JaxWsImplementorInfo ii) {
        if (ii.isWebServiceProvider()) {
            this.jaxWsConfiguration = new WebServiceProviderConfiguration();
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            this.setWrapped(false);
            this.setDataBinding(new SourceDataBinding());
            this.setMethodDispatcher(new JAXWSProviderMethodDispatcher(this.implInfo));
        } else {
            XmlSchema schema;
            this.jaxWsConfiguration = new JaxWsServiceConfiguration();
            this.jaxWsConfiguration.setServiceFactory(this);
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            Class<?> seiClass = ii.getEndpointClass();
            if (seiClass != null && seiClass.getPackage() != null && (schema = seiClass.getPackage().getAnnotation(XmlSchema.class)) != null && XmlNsForm.QUALIFIED.equals((Object)schema.elementFormDefault())) {
                this.setQualifyWrapperSchema(true);
            }
            this.setMethodDispatcher(new JAXWSMethodDispatcher(this.implInfo));
        }
        this.loadWSFeatureAnnotation(ii.getSEIClass(), ii.getImplementorClass());
    }

    public List<WebServiceFeature> getWsFeatures() {
        return this.wsFeatures;
    }

    public void setWsFeatures(List<WebServiceFeature> wsFeatures) {
        this.wsFeatures = wsFeatures;
    }

    private FaultInfo getFaultInfo(OperationInfo operation, Class expClass) {
        for (FaultInfo fault : operation.getFaults()) {
            if (fault.getProperty(Class.class.getName()) != expClass && fault.getProperty(Class.class.getName()) != expClass) continue;
            return fault;
        }
        return null;
    }

    private void buildWSAActions(OperationInfo operation, Method method) {
        FaultAction[] faultActions;
        MessageInfo output;
        if (method == null) {
            return;
        }
        Action action = method.getAnnotation(Action.class);
        if (action == null) {
            return;
        }
        MessageInfo input = operation.getInput();
        if (!StringUtils.isEmpty(action.input())) {
            input.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, action.input());
        }
        if ((output = operation.getOutput()) != null && !StringUtils.isEmpty(action.output())) {
            output.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, action.output());
        }
        if ((faultActions = action.fault()) != null && faultActions.length > 0 && operation.getFaults() != null) {
            for (FaultAction faultAction : faultActions) {
                FaultInfo faultInfo = this.getFaultInfo(operation, faultAction.className());
                faultInfo.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, faultAction.value());
                if (!operation.isUnwrappedCapable()) continue;
                faultInfo = this.getFaultInfo(operation.getUnwrappedOperation(), faultAction.className());
                faultInfo.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, faultAction.value());
            }
        }
    }

    @Override
    protected OperationInfo createOperation(ServiceInfo serviceInfo, InterfaceInfo intf, Method m) {
        OperationInfo op = super.createOperation(serviceInfo, intf, m);
        if (op.getUnwrappedOperation() != null) {
            op = op.getUnwrappedOperation();
        }
        this.buildWSAActions(op, m);
        return op;
    }

    @Override
    protected Set<Class<?>> getExtraClass() {
        XmlSeeAlso xmlSeeAlsoAnno;
        HashSet classes = new HashSet();
        if (!this.wrapperBeanGenerated) {
            this.wrapperClasses = this.generatedWrapperBeanClass();
        }
        if (this.wrapperClasses != null) {
            classes.addAll(this.wrapperClasses);
        }
        if ((xmlSeeAlsoAnno = this.getServiceClass().getAnnotation(XmlSeeAlso.class)) != null && xmlSeeAlsoAnno.value() != null) {
            for (int i = 0; i < xmlSeeAlsoAnno.value().length; ++i) {
                classes.add(xmlSeeAlsoAnno.value()[i]);
            }
        }
        return classes;
    }

    private Set<Class<?>> generatedWrapperBeanClass() {
        if (this.getDataBinding() instanceof JAXBDataBinding) {
            ServiceInfo serviceInfo = this.getService().getServiceInfos().get(0);
            WrapperClassGenerator wrapperGen = new WrapperClassGenerator(this, serviceInfo.getInterface(), this.getQualifyWrapperSchema());
            return wrapperGen.generate();
        }
        return Collections.emptySet();
    }

    @Override
    protected void buildServiceFromClass() {
        super.buildServiceFromClass();
        this.getService().put(WS_FEATURES, this.getWsFeatures());
    }
}

