/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDLCorbaWriterImpl
extends WSDLWriterImpl {
    public static final int DEFAULT_INDENT_LEVEL = 2;

    public void writeWSDL(Definition wsdlDef, Writer sink) throws WSDLException {
        PrintWriter pw = new PrintWriter(sink);
        String javaEncoding = sink instanceof OutputStreamWriter ? ((OutputStreamWriter)sink).getEncoding() : null;
        String xmlEncoding = DOM2Writer.java2XMLEncoding(javaEncoding);
        if (xmlEncoding == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Unsupported Java encoding for writing wsdl file: '" + javaEncoding + "'.");
        }
        pw.println("<?xml version=\"1.0\" encoding=\"" + xmlEncoding + "\"?>");
        this.printDefinition(wsdlDef, pw);
    }

    protected void printDefinition(Definition def, PrintWriter pw) throws WSDLException {
        if (def == null) {
            return;
        }
        if (def.getPrefix("http://schemas.xmlsoap.org/wsdl/") == null) {
            String prefix = "wsdl";
            int subscript = 0;
            while (def.getNamespace(prefix) != null) {
                prefix = "wsdl" + subscript++;
            }
            def.addNamespace(prefix, "http://schemas.xmlsoap.org/wsdl/");
        }
        String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "definitions", def);
        pw.print('<' + tagName);
        QName name = def.getQName();
        String targetNamespace = def.getTargetNamespace();
        Map namespaces = def.getNamespaces();
        if (name != null) {
            DOMUtils.printAttribute("name", name.getLocalPart(), pw);
        }
        DOMUtils.printAttribute("targetNamespace", targetNamespace, pw);
        this.printExtensibilityAttributes(Definition.class, def, def, pw);
        this.printNamespaceDeclarations(namespaces, pw);
        pw.println('>');
        this.printDocumentation(def.getDocumentationElement(), def, pw);
        List extElements = def.getExtensibilityElements();
        this.printExtensibilityElements(Definition.class, extElements, def, pw);
        this.printImports(def.getImports(), def, pw);
        this.printTypes(def.getTypes(), def, pw);
        this.printMessages(def.getMessages(), def, pw);
        this.printPortTypes(def.getPortTypes(), def, pw);
        this.printBindings(def.getBindings(), def, pw);
        this.printServices(def.getServices(), def, pw);
        pw.println("</" + tagName + '>');
        pw.flush();
    }

    public void printExtensibilityElements(Class class1, List list, Definition def, PrintWriter pw) throws WSDLException {
        if (list != null) {
            for (ExtensibilityElement extElement : list) {
                if (extElement instanceof Schema) {
                    Schema schemaElement = (Schema)extElement;
                    if (schemaElement.getElement() != null) {
                        this.printDOMElement(schemaElement.getElement(), pw, 4);
                    } else if (schemaElement.getImports() != null) {
                        this.printSchemaImports(extElement.getElementType(), schemaElement, pw, 4, def);
                    }
                    pw.println();
                    continue;
                }
                super.printExtensibilityElements(class1, list, def, pw);
            }
        }
    }

    private void printDOMElement(Element element, PrintWriter pw, int indentCount) {
        this.indent(pw, indentCount);
        pw.print("<" + element.getNodeName());
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            pw.print(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
        }
        pw.print(">");
        pw.println();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.printDOMElement((Element)node, pw, indentCount + 2);
            pw.println();
        }
        this.indent(pw, indentCount);
        pw.print("</" + element.getNodeName() + ">");
    }

    private void printSchemaImports(QName schemaName, Schema schemaElement, PrintWriter pw, int indentCount, Definition def) throws WSDLException {
        Map imports = schemaElement.getImports();
        this.indent(pw, indentCount);
        pw.print("<xsd:" + schemaName.getLocalPart() + ">");
        String tagName = "xsd:import";
        for (List importList : imports.values()) {
            for (SchemaImport schemaImport : importList) {
                pw.println();
                this.indent(pw, indentCount + 2);
                pw.print("<" + tagName);
                DOMUtils.printAttribute("namespace", schemaImport.getNamespaceURI(), pw);
                DOMUtils.printAttribute("schemaLocation", schemaImport.getSchemaLocationURI(), pw);
                pw.println("/>");
            }
        }
        this.indent(pw, indentCount);
        pw.print("</xsd:" + schemaName.getLocalPart() + ">");
    }

    public void indent(PrintWriter pw, int count) {
        for (int i = 0; i < count; ++i) {
            pw.print(' ');
        }
    }
}

