/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jws.Oneway;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.RequestWrapper;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.ResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrapperUtil {
    private WrapperUtil() {
    }

    public static boolean isWrapperClassExists(Method method) {
        RequestWrapper requestWrapper = new RequestWrapper();
        requestWrapper.setMethod(method);
        try {
            requestWrapper.getWrapperClass();
            boolean isOneWay = method.isAnnotationPresent(Oneway.class);
            if (!isOneWay) {
                ResponseWrapper responseWrapper = new ResponseWrapper();
                responseWrapper.setMethod(method);
                responseWrapper.getWrapperClass();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<Annotation> getJaxbAnnotations(Method method) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        Annotation ann = method.getAnnotation(XmlAttachmentRef.class);
        if (ann != null) {
            jaxbAnnotation.add(ann);
        }
        if ((ann = method.getAnnotation(XmlMimeType.class)) != null) {
            jaxbAnnotation.add(ann);
        }
        if ((ann = method.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
            jaxbAnnotation.add(ann);
        }
        if ((ann = method.getAnnotation(XmlList.class)) != null) {
            jaxbAnnotation.add(ann);
        }
        return jaxbAnnotation;
    }

    public static List<Annotation> getJaxbAnnotations(Method method, int idx) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        Annotation[][] anns = method.getParameterAnnotations();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i != idx) continue;
            for (Annotation ann : anns[i]) {
                if (ann.annotationType() != XmlAttachmentRef.class && ann.annotationType() != XmlMimeType.class && ann.annotationType() != XmlJavaTypeAdapter.class && ann.annotationType() != XmlList.class) continue;
                jaxbAnnotation.add(ann);
            }
        }
        return jaxbAnnotation;
    }
}

