/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolContainer;
import org.apache.cxf.tools.plugin.DataBinding;
import org.apache.cxf.tools.plugin.FrontEnd;
import org.apache.cxf.tools.plugin.Generator;
import org.apache.cxf.tools.plugin.Plugin;
import org.apache.cxf.tools.wsdlto.core.AbstractWSDLBuilder;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.FrontEndProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginLoader {
    public static final Logger LOG = LogUtils.getL7dLogger(PluginLoader.class);
    public static final String DEFAULT_PROVIDER_NAME = "cxf.apache.org";
    private static PluginLoader pluginLoader;
    private static final String PLUGIN_FILE_NAME = "META-INF/tools-plugin.xml";
    private Map<String, Plugin> plugins = new LinkedHashMap<String, Plugin>();
    private Map<String, FrontEnd> frontends = new LinkedHashMap<String, FrontEnd>();
    private Map<String, DataBinding> databindings = new TreeMap<String, DataBinding>();
    private Unmarshaller unmarshaller;
    private ClassLoader classLoader = this.getClass().getClassLoader();

    private PluginLoader() {
        this.init();
    }

    private PluginLoader(ClassLoader l) {
        this.classLoader = l;
        this.init();
    }

    private void init() {
        try {
            JAXBContext jc = JAXBContext.newInstance("org.apache.cxf.tools.plugin");
            this.unmarshaller = jc.createUnmarshaller();
            this.loadPlugins(ClassLoaderUtils.getResources(PLUGIN_FILE_NAME, this.getClass()));
        }
        catch (JAXBException e) {
            Message msg = new Message("JAXB_CONTEXT_INIT_FAIL", LOG, new Object[0]);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg);
        }
        catch (IOException ioe) {
            Message msg = new Message("LOAD_PLUGIN_EXCEPTION", LOG, new Object[0]);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg);
        }
    }

    public void refresh() {
        this.init();
    }

    public void setClassLoader(ClassLoader l) {
        this.classLoader = l;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void loadPlugins(List<URL> pluginFiles) throws IOException {
        if (pluginFiles == null) {
            LOG.log(Level.WARNING, "FOUND_NO_PLUGINS");
            return;
        }
        for (URL url : pluginFiles) {
            this.loadPlugin(url);
        }
    }

    public static PluginLoader getInstance() {
        if (pluginLoader == null) {
            pluginLoader = new PluginLoader();
        }
        return pluginLoader;
    }

    public static PluginLoader getInstance(ClassLoader cl) {
        if (pluginLoader == null) {
            pluginLoader = new PluginLoader(cl);
        }
        return pluginLoader;
    }

    public static void unload() {
        pluginLoader = null;
    }

    public void loadPlugin(URL url) throws IOException {
        try {
            LOG.log(Level.FINE, "PLUGIN_LOADING", url);
            this.loadPlugin(this.getPlugin(url));
        }
        catch (JAXBException e) {
            Message msg = new Message("PLUGIN_LOAD_FAIL", LOG, url);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
    }

    public void loadPlugin(String resource) {
        try {
            LOG.log(Level.FINE, "PLUGIN_LOADING", resource);
            this.loadPlugin(this.getPlugin(resource));
        }
        catch (JAXBException e) {
            Message msg = new Message("PLUGIN_LOAD_FAIL", LOG, resource);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        catch (FileNotFoundException fe) {
            Message msg = new Message("PLUGIN_FILE_NOT_FOUND", LOG, resource);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)fe);
        }
    }

    protected void loadPlugin(Plugin plugin) {
        Message msg;
        if (plugin.getFrontend().size() > 0) {
            LOG.log(Level.FINE, "FOUND_FRONTENDS", new Object[]{plugin.getName(), plugin.getFrontend().size()});
        }
        for (FrontEnd frontend : plugin.getFrontend()) {
            LOG.log(Level.FINE, "LOADING_FRONTEND", new Object[]{frontend.getName(), plugin.getName()});
            if (StringUtils.isEmpty(frontend.getName())) {
                LOG.log(Level.WARNING, "FRONTEND_MISSING_NAME", plugin.getName());
                continue;
            }
            if (this.frontends.containsKey(frontend.getName()) && DEFAULT_PROVIDER_NAME.equals(plugin.getProvider())) {
                msg = new Message("REPLACED_DEFAULT_FRONTEND", LOG, frontend.getName());
                LOG.log(Level.INFO, msg.toString());
                continue;
            }
            this.frontends.put(frontend.getName(), frontend);
        }
        if (plugin.getDatabinding().size() > 0) {
            LOG.log(Level.FINE, "FOUND_DATABINDINGS", new Object[]{plugin.getName(), plugin.getDatabinding().size()});
        }
        for (DataBinding databinding : plugin.getDatabinding()) {
            LOG.log(Level.FINE, "LOADING_DATABINDING", new Object[]{databinding.getName(), plugin.getName()});
            if (StringUtils.isEmpty(databinding.getName())) {
                LOG.log(Level.WARNING, "DATABINDING_MISSING_NAME", plugin.getName());
                continue;
            }
            if (this.databindings.containsKey(databinding.getName()) && DEFAULT_PROVIDER_NAME.equals(plugin.getProvider())) {
                msg = new Message("REPLACED_DEFAULT_DATABINDING", LOG, databinding.getName());
                LOG.log(Level.INFO, msg.toString());
                continue;
            }
            this.databindings.put(databinding.getName(), databinding);
        }
    }

    protected Plugin getPlugin(URL url) throws IOException, JAXBException, FileNotFoundException {
        Plugin plugin = this.plugins.get(url.toString());
        InputStream is = null;
        if (plugin == null) {
            is = url.openStream();
            plugin = this.getPlugin(is);
            if (plugin == null || StringUtils.isEmpty(plugin.getName())) {
                Message msg = new Message("PLUGIN_LOAD_FAIL", LOG, url);
                LOG.log(Level.SEVERE, msg.toString());
                throw new ToolException(msg);
            }
            this.plugins.put(url.toString(), plugin);
        }
        if (is == null) {
            return this.getPlugin(url.toString());
        }
        return plugin;
    }

    protected Plugin getPlugin(String resource) throws JAXBException, FileNotFoundException {
        Plugin plugin = this.plugins.get(resource);
        if (plugin == null) {
            InputStream is = null;
            is = new File(resource).exists() ? new BufferedInputStream(new FileInputStream(new File(resource))) : this.getClass().getResourceAsStream(resource);
            if (is == null) {
                Message msg = new Message("PLUGIN_MISSING", LOG, resource);
                LOG.log(Level.SEVERE, msg.toString());
                throw new ToolException(msg);
            }
            plugin = this.getPlugin(is);
            if (plugin == null || StringUtils.isEmpty(plugin.getName())) {
                Message msg = new Message("PLUGIN_LOAD_FAIL", LOG, resource);
                LOG.log(Level.SEVERE, msg.toString());
                throw new ToolException(msg);
            }
            this.plugins.put(resource, plugin);
        }
        return plugin;
    }

    private Plugin getPlugin(InputStream is) throws JAXBException {
        return (Plugin)((JAXBElement)this.unmarshaller.unmarshal(is)).getValue();
    }

    public FrontEnd getFrontEnd(String name) {
        FrontEnd frontend = this.frontends.get(name);
        if (frontend == null) {
            Message msg = new Message("FRONTEND_MISSING", LOG, name);
            throw new ToolException(msg);
        }
        return frontend;
    }

    private String getGeneratorClass(FrontEnd frontend, Generator generator) {
        String fullPackage = generator.getPackage();
        if (StringUtils.isEmpty(fullPackage)) {
            fullPackage = frontend.getGenerators().getPackage();
        }
        if (StringUtils.isEmpty(fullPackage)) {
            fullPackage = frontend.getPackage();
        }
        return fullPackage + "." + generator.getName();
    }

    private List<FrontEndGenerator> getFrontEndGenerators(FrontEnd frontend) {
        ArrayList<FrontEndGenerator> generators = new ArrayList<FrontEndGenerator>();
        String fullClzName = null;
        try {
            for (Generator generator : frontend.getGenerators().getGenerator()) {
                fullClzName = this.getGeneratorClass(frontend, generator);
                Class<?> clz = this.classLoader.loadClass(fullClzName);
                generators.add((FrontEndGenerator)clz.newInstance());
            }
        }
        catch (Exception e) {
            Message msg = new Message("FRONTEND_PROFILE_LOAD_FAIL", LOG, fullClzName);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        return generators;
    }

    private FrontEndProfile loadFrontEndProfile(String fullClzName) {
        FrontEndProfile profile = null;
        try {
            Class<?> clz = this.classLoader.loadClass(fullClzName);
            profile = (FrontEndProfile)clz.newInstance();
        }
        catch (Exception e) {
            Message msg = new Message("FRONTEND_PROFILE_LOAD_FAIL", LOG, fullClzName);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        return profile;
    }

    private Processor loadProcessor(String fullClzName) {
        Processor processor = null;
        try {
            processor = (Processor)ClassLoaderUtils.loadClass(fullClzName, this.getClass()).newInstance();
        }
        catch (Exception e) {
            Message msg = new Message("LOAD_PROCESSOR_FAILED", LOG, fullClzName);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        return processor;
    }

    private Class<? extends ToolContainer> loadContainerClass(String fullClzName) {
        Class<?> clz = null;
        try {
            clz = ClassLoaderUtils.loadClass(fullClzName, this.getClass());
        }
        catch (Exception e) {
            Message msg = new Message("LOAD_CONTAINER_CLASS_FAILED", LOG, fullClzName);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        if (!ToolContainer.class.isAssignableFrom(clz)) {
            Message message = new Message("CLZ_SHOULD_IMPLEMENT_INTERFACE", LOG, clz.getName());
            LOG.log(Level.SEVERE, message.toString());
            throw new ToolException(message);
        }
        return clz.asSubclass(ToolContainer.class);
    }

    private String getFrontEndProfileClass(FrontEnd frontend) {
        if (StringUtils.isEmpty(frontend.getProfile())) {
            return "org.apache.cxf.tools.wsdlto.core.FrontEndProfile";
        }
        return frontend.getPackage() + "." + frontend.getProfile();
    }

    private String getProcessorClass(FrontEnd frontend) {
        String pkgName = frontend.getProcessor().getPackage();
        if (StringUtils.isEmpty(pkgName)) {
            pkgName = frontend.getPackage();
        }
        return pkgName + "." + frontend.getProcessor().getName();
    }

    private String getContainerClass(FrontEnd frontend) {
        return this.getContainerPackage(frontend) + "." + frontend.getContainer().getName();
    }

    private String getContainerPackage(FrontEnd frontend) {
        String pkgName = frontend.getContainer().getPackage();
        if (StringUtils.isEmpty(pkgName)) {
            pkgName = frontend.getPackage();
        }
        return pkgName;
    }

    private String getToolspec(FrontEnd frontend) {
        String toolspec = frontend.getContainer().getToolspec();
        return "/" + this.getContainerPackage(frontend).replace(".", "/") + "/" + toolspec;
    }

    private AbstractWSDLBuilder<? extends Object> loadBuilder(String fullClzName) {
        AbstractWSDLBuilder builder = null;
        try {
            builder = (AbstractWSDLBuilder)ClassLoaderUtils.loadClass(fullClzName, this.getClass()).newInstance();
        }
        catch (Exception e) {
            Message msg = new Message("LOAD_PROCESSOR_FAILED", LOG, fullClzName);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        return builder;
    }

    private String getBuilderClass(FrontEnd frontend) {
        String pkgName = frontend.getBuilder().getPackage();
        if (StringUtils.isEmpty(pkgName)) {
            pkgName = frontend.getPackage();
        }
        return pkgName + "." + frontend.getBuilder().getName();
    }

    public FrontEndProfile getFrontEndProfile(String name) {
        FrontEndProfile profile = null;
        FrontEnd frontend = this.getFrontEnd(name);
        profile = this.loadFrontEndProfile(this.getFrontEndProfileClass(frontend));
        for (FrontEndGenerator generator : this.getFrontEndGenerators(frontend)) {
            profile.registerGenerator(generator);
        }
        if (frontend.getProcessor() != null) {
            profile.setProcessor(this.loadProcessor(this.getProcessorClass(frontend)));
        }
        if (frontend.getContainer() != null) {
            profile.setContainerClass(this.loadContainerClass(this.getContainerClass(frontend)));
            profile.setToolspec(this.getToolspec(frontend));
        }
        if (frontend.getBuilder() != null) {
            profile.setWSDLBuilder(this.loadBuilder(this.getBuilderClass(frontend)));
        }
        return profile;
    }

    public DataBinding getDataBinding(String name) {
        DataBinding databinding = this.databindings.get(name);
        if (databinding == null) {
            Message msg = new Message("DATABINDING_MISSING", LOG, name);
            throw new ToolException(msg);
        }
        return databinding;
    }

    private DataBindingProfile loadDataBindingProfile(String fullClzName) {
        DataBindingProfile profile = null;
        try {
            profile = (DataBindingProfile)ClassLoaderUtils.loadClass(fullClzName, this.getClass()).newInstance();
        }
        catch (Exception e) {
            Message msg = new Message("DATABINDING_PROFILE_LOAD_FAIL", LOG, fullClzName);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg);
        }
        return profile;
    }

    public DataBindingProfile getDataBindingProfile(String name) {
        DataBindingProfile profile = null;
        DataBinding databinding = this.getDataBinding(name);
        profile = this.loadDataBindingProfile(databinding.getPackage() + "." + databinding.getProfile());
        return profile;
    }

    public Map<String, FrontEnd> getFrontEnds() {
        return this.frontends;
    }

    public Map<String, DataBinding> getDataBindings() {
        return this.databindings;
    }

    public Map<String, Plugin> getPlugins() {
        return this.plugins;
    }
}

