/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyUtils;

public class ClientPolicyOutInterceptor
extends AbstractPolicyInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientPolicyOutInterceptor.class);

    public ClientPolicyOutInterceptor() {
        super("org.apache.cxf.ws.policy.ClientPolicyOutInterceptor", "setup");
    }

    protected void handle(Message msg) {
        if (!MessageUtils.isRequestor(msg)) {
            LOG.fine("Not a requestor.");
            return;
        }
        Exchange exchange = msg.getExchange();
        assert (null != exchange);
        BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            LOG.fine("No binding operation info.");
            return;
        }
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Conduit conduit = exchange.getConduit(msg);
        EffectivePolicy effectivePolicy = pe.getEffectiveClientRequestPolicy(ei, boi, conduit);
        msg.put(EffectivePolicy.class, effectivePolicy);
        PolicyUtils.logPolicy(LOG, Level.FINEST, "Using effective policy: ", effectivePolicy.getPolicy());
        List<Interceptor> interceptors = effectivePolicy.getInterceptors();
        for (Interceptor i : interceptors) {
            msg.getInterceptorChain().add(i);
            LOG.log(Level.INFO, "Added interceptor of type {0}", i.getClass().getSimpleName());
        }
        Collection<PolicyAssertion> assertions = effectivePolicy.getChosenAlternative();
        if (null != assertions) {
            if (LOG.isLoggable(Level.FINEST)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Chosen alternative: ");
                String nl = System.getProperty("line.separator");
                buf.append(nl);
                for (PolicyAssertion a : assertions) {
                    PolicyUtils.printPolicyComponent(a, buf, 1);
                }
                LOG.finest(buf.toString());
            }
            msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
        }
    }
}

