/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.builder.primitive.NestedPrimitiveAssertion;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyUtils {
    private static final String INDENT = "  ";

    private PolicyUtils() {
    }

    public static boolean contains(Collection<Assertion> assertions, Assertion candidate) {
        for (Assertion a : assertions) {
            if (!a.equal(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection<Assertion> assertions, Collection<Assertion> candidates) {
        if (null == candidates || candidates.isEmpty()) {
            return true;
        }
        for (Assertion c : candidates) {
            if (PolicyUtils.contains(assertions, c)) continue;
            return false;
        }
        return true;
    }

    public static void logPolicy(Logger log, Level level, String msg, PolicyComponent pc) {
        if (null == pc) {
            log.log(level, msg);
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(msg);
        PolicyUtils.nl(buf);
        PolicyUtils.printPolicyComponent(pc, buf, 0);
        log.log(level, buf.toString());
    }

    public static void printPolicyComponent(PolicyComponent pc) {
        StringBuffer buf = new StringBuffer();
        PolicyUtils.printPolicyComponent(pc, buf, 0);
        System.out.println(buf.toString());
    }

    public static void printPolicyComponent(PolicyComponent pc, StringBuffer buf, int level) {
        PolicyUtils.indent(buf, level);
        buf.append("type: ");
        buf.append(PolicyUtils.typeToString(pc.getType()));
        if (5 == pc.getType()) {
            buf.append(" ");
            buf.append(((Assertion)pc).getName());
            if (((Assertion)pc).isOptional()) {
                buf.append(" (optional)");
            }
            buf.append(" (");
            buf.append((Assertion)pc);
            buf.append(")");
            PolicyUtils.nl(buf);
            if (pc instanceof NestedPrimitiveAssertion) {
                Policy nested = ((NestedPrimitiveAssertion)pc).getPolicy();
                PolicyUtils.printPolicyComponent(nested, buf, ++level);
                --level;
            }
        } else {
            ++level;
            List<PolicyComponent> children = CastUtils.cast(((PolicyOperator)pc).getPolicyComponents(), PolicyComponent.class);
            PolicyUtils.nl(buf);
            for (PolicyComponent child : children) {
                PolicyUtils.printPolicyComponent(child, buf, level);
            }
            --level;
        }
    }

    private static void indent(StringBuffer buf, int level) {
        for (int i = 0; i < level; ++i) {
            buf.append(INDENT);
        }
    }

    private static void nl(StringBuffer buf) {
        buf.append(System.getProperty("line.separator"));
    }

    private static String typeToString(short type) {
        switch (type) {
            case 5: {
                return "Assertion";
            }
            case 3: {
                return "All";
            }
            case 2: {
                return "ExactlyOne";
            }
            case 1: {
                return "Policy";
            }
            case 4: {
                return "PolicyReference";
            }
        }
        return "";
    }
}

