/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;

public class SignatureToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token signatureToken;

    public SignatureToken(SPConstants version2) {
        super(version2);
    }

    public Token getSignatureToken() {
        return this.signatureToken;
    }

    public void setSignatureToken(Token signatureToken) {
        this.signatureToken = signatureToken;
    }

    public void setToken(Token tok) {
        this.setSignatureToken(tok);
    }

    public QName getName() {
        return this.constants.getSignatureToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String wspNamespaceURI;
        String wspWriterPrefix;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((wspWriterPrefix = writer.getPrefix(wspNamespaceURI = SPConstants.POLICY.getNamespaceURI())) == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, wspNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), wspNamespaceURI);
        if (wspWriterPrefix == null) {
            writer.writeNamespace(wspPrefix, wspNamespaceURI);
        }
        if (this.signatureToken == null) {
            throw new RuntimeException("EncryptionToken is not set");
        }
        this.signatureToken.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

