/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.neethi.PolicyComponent;

public class Wss10
extends AbstractSecurityAssertion {
    private boolean mustSupportRefKeyIdentifier;
    private boolean mustSupportRefIssuerSerial;
    private boolean mustSupportRefExternalURI;
    private boolean mustSupportRefEmbeddedToken;

    public Wss10(SPConstants version2) {
        super(version2);
    }

    public boolean isMustSupportRefEmbeddedToken() {
        return this.mustSupportRefEmbeddedToken;
    }

    public void setMustSupportRefEmbeddedToken(boolean mustSupportRefEmbeddedToken) {
        this.mustSupportRefEmbeddedToken = mustSupportRefEmbeddedToken;
    }

    public boolean isMustSupportRefExternalURI() {
        return this.mustSupportRefExternalURI;
    }

    public void setMustSupportRefExternalURI(boolean mustSupportRefExternalURI) {
        this.mustSupportRefExternalURI = mustSupportRefExternalURI;
    }

    public boolean isMustSupportRefIssuerSerial() {
        return this.mustSupportRefIssuerSerial;
    }

    public void setMustSupportRefIssuerSerial(boolean mustSupportRefIssuerSerial) {
        this.mustSupportRefIssuerSerial = mustSupportRefIssuerSerial;
    }

    public boolean isMustSupportRefKeyIdentifier() {
        return this.mustSupportRefKeyIdentifier;
    }

    public void setMustSupportRefKeyIdentifier(boolean mustSupportRefKeyIdentifier) {
        this.mustSupportRefKeyIdentifier = mustSupportRefKeyIdentifier;
    }

    public QName getName() {
        return this.constants.getWSS10();
    }

    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(prefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isMustSupportRefKeyIdentifier()) {
            writer.writeStartElement(prefix, "MustSupportRefKeyIdentifier", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefIssuerSerial()) {
            writer.writeStartElement(prefix, "MustSupportRefIssuerSerial", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefExternalURI()) {
            writer.writeStartElement(prefix, "MustSupportRefExternalURI", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            writer.writeStartElement(prefix, "MustSupportRefEmbeddedToken", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

