/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.PolicyComponent;

public class X509Token
extends Token {
    private boolean requireKeyIdentifierReference;
    private boolean requireIssuerSerialReference;
    private boolean requireEmbeddedTokenReference;
    private boolean requireThumbprintReference;
    private String tokenVersionAndType = "WssX509V3Token10";

    public X509Token(SPConstants version2) {
        super(version2);
    }

    public boolean isRequireEmbeddedTokenReference() {
        return this.requireEmbeddedTokenReference;
    }

    public void setRequireEmbeddedTokenReference(boolean requireEmbeddedTokenReference) {
        this.requireEmbeddedTokenReference = requireEmbeddedTokenReference;
    }

    public boolean isRequireIssuerSerialReference() {
        return this.requireIssuerSerialReference;
    }

    public void setRequireIssuerSerialReference(boolean requireIssuerSerialReference) {
        this.requireIssuerSerialReference = requireIssuerSerialReference;
    }

    public boolean isRequireKeyIdentifierReference() {
        return this.requireKeyIdentifierReference;
    }

    public void setRequireKeyIdentifierReference(boolean requireKeyIdentifierReference) {
        this.requireKeyIdentifierReference = requireKeyIdentifierReference;
    }

    public boolean isRequireThumbprintReference() {
        return this.requireThumbprintReference;
    }

    public void setRequireThumbprintReference(boolean requireThumbprintReference) {
        this.requireThumbprintReference = requireThumbprintReference;
    }

    public String getTokenVersionAndType() {
        return this.tokenVersionAndType;
    }

    public void setTokenVersionAndType(String tokenVersionAndType) {
        this.tokenVersionAndType = tokenVersionAndType;
    }

    public QName getName() {
        return this.constants.getX509Token();
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String pPrefix;
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if ((pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI())) == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isRequireKeyIdentifierReference()) {
            writer.writeStartElement(prefix, "RequireKeyIdentifierReference", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireIssuerSerialReference()) {
            writer.writeStartElement(prefix, "RequireIssuerSerialReference", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireEmbeddedTokenReference()) {
            writer.writeStartElement(prefix, "RequireEmbeddedTokenReference", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireThumbprintReference()) {
            writer.writeStartElement(prefix, "RequireThumbprintReference", namespaceURI);
            writer.writeEndElement();
        }
        if (this.tokenVersionAndType != null) {
            writer.writeStartElement(prefix, this.tokenVersionAndType, namespaceURI);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys()) {
            writer.writeStartElement(prefix, "RequireDerivedKeys", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

