/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrintXMLStreamWriter
implements XMLStreamWriter {
    static final Map<Class<?>, Integer> WSDL_INDENT_MAP = new HashMap();
    static final int DEFAULT_INDENT_LEVEL = 2;
    XMLStreamWriter baseWriter;
    int indent;
    Stack<CurrentElement> elems = new Stack();
    QName currElem;
    boolean nestedStartElement;

    public PrettyPrintXMLStreamWriter(XMLStreamWriter writer, Class<?> parent) {
        this.baseWriter = writer;
        this.indent = this.getIndentLevel(parent);
    }

    public void writeSpaces() throws XMLStreamException {
        for (int i = 0; i < this.indent; ++i) {
            this.baseWriter.writeCharacters(" ");
        }
    }

    public void indentWithSpaces() throws XMLStreamException {
        this.writeSpaces();
        this.indent();
    }

    public void indent() {
        this.indent += 2;
    }

    public void unindent() {
        this.indent -= 2;
    }

    @Override
    public void close() throws XMLStreamException {
        this.baseWriter.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.baseWriter.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.baseWriter.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.baseWriter.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.baseWriter.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.baseWriter.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.baseWriter.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.baseWriter.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.baseWriter.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.baseWriter.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.baseWriter.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.baseWriter.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.baseWriter.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.baseWriter.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.baseWriter.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.baseWriter.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.baseWriter.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.baseWriter.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.baseWriter.writeEmptyElement(localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.baseWriter.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.baseWriter.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        CurrentElement elem = this.elems.pop();
        this.unindent();
        if (elem.hasChildElements()) {
            this.baseWriter.writeCharacters("\n");
            this.writeSpaces();
        }
        this.baseWriter.writeEndElement();
        if (this.elems.empty()) {
            this.baseWriter.writeCharacters("\n");
        }
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.baseWriter.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.baseWriter.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.baseWriter.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.baseWriter.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.baseWriter.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version2) throws XMLStreamException {
        this.baseWriter.writeStartDocument(version2);
    }

    @Override
    public void writeStartDocument(String encoding, String version2) throws XMLStreamException {
        this.baseWriter.writeStartDocument(encoding, version2);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, null, localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(null, namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        QName currElemName = new QName(namespaceURI, localName);
        if (this.elems.empty()) {
            this.indentWithSpaces();
        } else {
            this.baseWriter.writeCharacters("");
            this.baseWriter.writeCharacters("\n");
            this.indentWithSpaces();
            CurrentElement elem = this.elems.peek();
            elem.setChildElements(true);
        }
        if (prefix == null && namespaceURI == null) {
            this.baseWriter.writeStartElement(localName);
        } else if (prefix == null) {
            this.baseWriter.writeStartElement(namespaceURI, localName);
        } else {
            this.baseWriter.writeStartElement(prefix, localName, namespaceURI);
        }
        this.elems.push(new CurrentElement(currElemName));
    }

    private int getIndentLevel(Class<?> parent) {
        Integer result = WSDL_INDENT_MAP.get(parent);
        if (result == null) {
            return 2;
        }
        return result;
    }

    static {
        WSDL_INDENT_MAP.put(Definition.class, new Integer(2));
        WSDL_INDENT_MAP.put(Binding.class, new Integer(4));
        WSDL_INDENT_MAP.put(BindingFault.class, new Integer(6));
        WSDL_INDENT_MAP.put(BindingInput.class, new Integer(6));
        WSDL_INDENT_MAP.put(BindingOutput.class, new Integer(6));
        WSDL_INDENT_MAP.put(BindingOperation.class, new Integer(6));
        WSDL_INDENT_MAP.put(Message.class, new Integer(4));
        WSDL_INDENT_MAP.put(Operation.class, new Integer(6));
        WSDL_INDENT_MAP.put(Port.class, new Integer(6));
        WSDL_INDENT_MAP.put(Service.class, new Integer(4));
        WSDL_INDENT_MAP.put(Types.class, new Integer(4));
    }

    class CurrentElement {
        private QName name;
        private boolean hasChildElements;

        CurrentElement(QName qname) {
            this.name = qname;
        }

        public QName getQName() {
            return this.name;
        }

        public boolean hasChildElements() {
            return this.hasChildElements;
        }

        public void setChildElements(boolean childElements) {
            this.hasChildElements = childElements;
        }
    }
}

