/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstValue
extends SimpleNode {
    protected static final boolean COERCE_TO_ZERO = Boolean.valueOf(System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "true"));

    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        return ctx.getELResolver().getType(ctx, t.base, t.property);
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        int i;
        Object base = this.children[0].getValue(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren() - 1;
        ELResolver resolver2 = ctx.getELResolver();
        if (propCount > 1) {
            for (i = 1; base != null && i < propCount; ++i) {
                property = this.children[i].getValue(ctx);
                ctx.setPropertyResolved(false);
                base = resolver2.getValue(ctx, base, property);
            }
            if (base == null || property == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        if ((property = this.children[i].getValue(ctx)) == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[i]));
        }
        Target t = new Target();
        t.base = base;
        t.property = property;
        return t;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        Object property = null;
        ELResolver resolver2 = ctx.getELResolver();
        for (int i = 1; base != null && i < propCount; ++i) {
            property = this.children[i].getValue(ctx);
            if (property == null) {
                return null;
            }
            ctx.setPropertyResolved(false);
            base = resolver2.getValue(ctx, base, property);
        }
        return base;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        return ctx.getELResolver().isReadOnly(ctx, t.base, t.property);
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        ELResolver resolver2 = ctx.getELResolver();
        Class<?> targetClass = resolver2.getType(ctx, t.base, t.property);
        if (COERCE_TO_ZERO || !this.isAssignable(value, targetClass)) {
            value = ELSupport.coerceToType(value, targetClass);
        }
        resolver2.setValue(ctx, t.base, t.property, value);
    }

    private boolean isAssignable(Object value, Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        if (value != null && targetClass.isPrimitive()) {
            return false;
        }
        return value == null || targetClass.isInstance(value);
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        return new MethodInfo(m.getName(), m.getReturnType(), m.getParameterTypes());
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        Object result = null;
        try {
            result = m.invoke(t.base, paramValues);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        return result;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

