/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.dependencymanager.ConfigurationDependency;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceDependency;
import org.apache.felix.dependencymanager.ServiceImpl;
import org.osgi.framework.BundleContext;

public class DependencyManager {
    private final BundleContext m_context;
    private final Logger m_logger;
    private List m_services = Collections.synchronizedList(new ArrayList());

    public DependencyManager(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
    }

    public void add(Service service) {
        this.m_services.add(service);
        service.start();
    }

    public void remove(Service service) {
        service.stop();
        this.m_services.remove(service);
    }

    public Service createService() {
        return new ServiceImpl(this.m_context, this.m_logger);
    }

    public ServiceDependency createServiceDependency() {
        return new ServiceDependency(this.m_context, this.m_logger);
    }

    public ConfigurationDependency createConfigurationDependency() {
        return new ConfigurationDependency(this.m_context, this.m_logger);
    }

    public List getServices() {
        return Collections.unmodifiableList(this.m_services);
    }
}

