/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.ws.scout.registry.BulkResponseImpl;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.IRegistry;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.uddi.AssertionStatusItem;
import org.apache.ws.scout.uddi.AssertionStatusReport;
import org.apache.ws.scout.uddi.AuthToken;
import org.apache.ws.scout.uddi.BindingDetail;
import org.apache.ws.scout.uddi.BindingTemplate;
import org.apache.ws.scout.uddi.BusinessDetail;
import org.apache.ws.scout.uddi.BusinessEntity;
import org.apache.ws.scout.uddi.BusinessInfo;
import org.apache.ws.scout.uddi.BusinessList;
import org.apache.ws.scout.uddi.BusinessService;
import org.apache.ws.scout.uddi.FindQualifiers;
import org.apache.ws.scout.uddi.KeyedReference;
import org.apache.ws.scout.uddi.Name;
import org.apache.ws.scout.uddi.PublisherAssertion;
import org.apache.ws.scout.uddi.PublisherAssertions;
import org.apache.ws.scout.uddi.ServiceDetail;
import org.apache.ws.scout.uddi.ServiceInfo;
import org.apache.ws.scout.uddi.ServiceInfos;
import org.apache.ws.scout.uddi.ServiceList;
import org.apache.ws.scout.uddi.TModel;
import org.apache.ws.scout.uddi.TModelDetail;
import org.apache.ws.scout.uddi.TModelInfo;
import org.apache.ws.scout.uddi.TModelInfos;
import org.apache.ws.scout.uddi.TModelList;
import org.apache.ws.scout.util.EnumerationHelper;
import org.apache.ws.scout.util.ScoutJaxrUddiHelper;
import org.apache.ws.scout.util.ScoutUddiJaxrHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessQueryManagerImpl
implements BusinessQueryManager {
    private final RegistryServiceImpl registryService;

    public BusinessQueryManagerImpl(RegistryServiceImpl registry) {
        this.registryService = registry;
    }

    @Override
    public RegistryService getRegistryService() {
        return this.registryService;
    }

    @Override
    public BulkResponse findOrganizations(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        try {
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
            Name[] nameArray = BusinessQueryManagerImpl.mapNamePatterns(namePatterns);
            BusinessList result = registry.findBusiness(nameArray, null, ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(externalIdentifiers), ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), null, juddiFindQualifiers, this.registryService.getMaxRows());
            BusinessInfo[] a = result.getBusinessInfos() != null ? result.getBusinessInfos().getBusinessInfoArray() : null;
            LinkedHashSet<Organization> orgs = null;
            int len = 0;
            if (a != null) {
                len = a.length;
                orgs = new LinkedHashSet<Organization>();
            }
            for (int i = 0; i < len; ++i) {
                BusinessInfo info = a[i];
                BusinessDetail detail = registry.getBusinessDetail(info.getBusinessKey());
                orgs.add(this.registryService.getLifeCycleManagerImpl().createOrganization(detail));
            }
            return new BulkResponseImpl(orgs);
        }
        catch (RegistryException e) {
            throw new JAXRException(e);
        }
    }

    @Override
    public BulkResponse findAssociations(Collection findQualifiers, String sourceObjectId, String targetObjectId, Collection associationTypes) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            PublisherAssertions result = registry.getPublisherAssertions(auth.getAuthInfo());
            PublisherAssertion[] a = result.getPublisherAssertionArray();
            LinkedHashSet<Association> col = null;
            int len = 0;
            if (a != null) {
                len = a.length;
                col = new LinkedHashSet<Association>();
            }
            for (int i = 0; i < len; ++i) {
                PublisherAssertion pas = a[i];
                String sourceKey = pas.getFromKey();
                String targetKey = pas.getToKey();
                ArrayList<Key> orgcol = new ArrayList<Key>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiJaxrHelper.getAssociation(bl.getCollection(), this.registryService.getBusinessLifeCycleManager());
                KeyedReference keyr = pas.getKeyedReference();
                ConceptImpl c = new ConceptImpl(this.getRegistryService().getBusinessLifeCycleManager());
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setValue(keyr.getKeyValue());
                asso.setAssociationType(c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException(e);
        }
    }

    @Override
    public BulkResponse findCallerAssociations(Collection findQualifiers, Boolean confirmedByCaller, Boolean confirmedByOtherParty, Collection associationTypes) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            AssertionStatusReport report = null;
            String confirm = "";
            boolean caller = confirmedByCaller;
            boolean other = confirmedByOtherParty;
            if (caller && other) {
                confirm = "status:complete";
            } else if (!caller && other) {
                confirm = "status:fromKey_incomplete";
            } else if (caller && !other) {
                confirm = "status:toKey_incomplete";
            }
            report = registry.getAssertionStatusReport(auth.getAuthInfo(), confirm);
            AssertionStatusItem[] a = report.getAssertionStatusItemArray();
            LinkedHashSet<Association> col = null;
            int len = 0;
            if (a != null) {
                len = a.length;
                col = new LinkedHashSet<Association>();
            }
            for (int i = 0; i < len; ++i) {
                AssertionStatusItem asi = a[i];
                String sourceKey = asi.getFromKey();
                String targetKey = asi.getToKey();
                ArrayList<Key> orgcol = new ArrayList<Key>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiJaxrHelper.getAssociation(bl.getCollection(), this.registryService.getBusinessLifeCycleManager());
                ((AssociationImpl)asso).setConfirmedBySourceOwner(caller);
                ((AssociationImpl)asso).setConfirmedByTargetOwner(other);
                if (confirm != "status:complete") {
                    ((AssociationImpl)asso).setConfirmed(false);
                }
                ConceptImpl c = new ConceptImpl(this.getRegistryService().getBusinessLifeCycleManager());
                KeyedReference keyr = asi.getKeyedReference();
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setValue(keyr.getKeyValue());
                asso.setKey(new KeyImpl(keyr.getTModelKey()));
                asso.setAssociationType(c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException(e);
        }
    }

    @Override
    public ClassificationScheme findClassificationSchemeByName(Collection findQualifiers, String namePatterns) throws JAXRException {
        ClassificationSchemeImpl scheme = null;
        if (namePatterns.indexOf("uddi-org:types") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4"));
        } else if (namePatterns.indexOf("dnb-com:D-U-N-S") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("unspsc-org:unspsc") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
        } else if (namePatterns.indexOf("ntis-gov:naics") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2"));
        } else if ("AssociationType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "RelatedTo");
            this.addChildConcept(scheme, "HasChild");
            this.addChildConcept(scheme, "HasMember");
            this.addChildConcept(scheme, "HasParent");
            this.addChildConcept(scheme, "ExternallyLinks");
            this.addChildConcept(scheme, "Contains");
            this.addChildConcept(scheme, "EquivalentTo");
            this.addChildConcept(scheme, "Extends");
            this.addChildConcept(scheme, "Implements");
            this.addChildConcept(scheme, "InstanceOf");
            this.addChildConcept(scheme, "Supersedes");
            this.addChildConcept(scheme, "Uses");
            this.addChildConcept(scheme, "Replaces");
            this.addChildConcept(scheme, "ResponsibleFor");
            this.addChildConcept(scheme, "SubmitterOf");
        } else if ("ObjectType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "CPP");
            this.addChildConcept(scheme, "CPA");
            this.addChildConcept(scheme, "Process");
            this.addChildConcept(scheme, "WSDL");
            this.addChildConcept(scheme, "Association");
            this.addChildConcept(scheme, "AuditableEvent");
            this.addChildConcept(scheme, "Classification");
            this.addChildConcept(scheme, "Concept");
            this.addChildConcept(scheme, "ExternalIdentifier");
            this.addChildConcept(scheme, "ExternalLink");
            this.addChildConcept(scheme, "ExtrinsicObject");
            this.addChildConcept(scheme, "Organization");
            this.addChildConcept(scheme, "Package");
            this.addChildConcept(scheme, "Service");
            this.addChildConcept(scheme, "ServiceBinding");
            this.addChildConcept(scheme, "User");
        } else if ("PhoneType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "OfficePhone");
            this.addChildConcept(scheme, "HomePhone");
            this.addChildConcept(scheme, "MobilePhone");
            this.addChildConcept(scheme, "Beeper");
            this.addChildConcept(scheme, "FAX");
        } else if ("URLType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "HTTP");
            this.addChildConcept(scheme, "HTTPS");
            this.addChildConcept(scheme, "SMTP");
            this.addChildConcept(scheme, "PHONE");
            this.addChildConcept(scheme, "FAX");
            this.addChildConcept(scheme, "OTHER");
        } else if ("PostalAddressAttributes".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "StreetNumber");
            this.addChildConcept(scheme, "Street");
            this.addChildConcept(scheme, "City");
            this.addChildConcept(scheme, "State");
            this.addChildConcept(scheme, "PostalCode");
            this.addChildConcept(scheme, "Country");
        } else {
            IRegistry registry = this.registryService.getRegistry();
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
            try {
                TModelList list = registry.findTModel(namePatterns, null, null, juddiFindQualifiers, 3);
                TModelInfos infos = null;
                TModelInfo[] tmarr = null;
                if (list != null) {
                    infos = list.getTModelInfos();
                }
                if (infos != null) {
                    tmarr = infos.getTModelInfoArray();
                }
                if (tmarr != null && tmarr.length > 0) {
                    if (tmarr.length > 1) {
                        throw new InvalidRequestException("Multiple matches found");
                    }
                    TModelInfo info = tmarr[0];
                    scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
                    scheme.setName(new InternationalStringImpl(info.getName().getStringValue()));
                    scheme.setKey(new KeyImpl(info.getTModelKey()));
                }
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return scheme;
    }

    private void addChildConcept(ClassificationSchemeImpl scheme, String name) throws JAXRException {
        ConceptImpl c = new ConceptImpl(this.registryService.getLifeCycleManagerImpl());
        c.setName(new InternationalStringImpl(name));
        c.setValue(name);
        c.setScheme(scheme);
        scheme.addChildConcept(c);
    }

    @Override
    public BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        LinkedHashSet<ClassificationScheme> col = new LinkedHashSet<ClassificationScheme>();
        Iterator iter = namePatterns.iterator();
        String name = "";
        if (iter.hasNext()) {
            name = (String)iter.next();
        }
        col.add(this.findClassificationSchemeByName(findQualifiers, name));
        return new BulkResponseImpl(col);
    }

    @Override
    public Concept findConceptByPath(String path) throws JAXRException {
        return EnumerationHelper.getConceptByPath(path);
    }

    @Override
    public BulkResponse findConcepts(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        LinkedHashSet<Concept> col = new LinkedHashSet<Concept>();
        IRegistry registry = this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        Iterator iter = null;
        if (namePatterns != null) {
            iter = namePatterns.iterator();
        }
        while (iter.hasNext()) {
            String namestr = (String)iter.next();
            try {
                TModelList list = registry.findTModel(namestr, ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(externalIdentifiers), juddiFindQualifiers, 10);
                TModelInfos infos = null;
                TModelInfo[] tmarr = null;
                if (list != null) {
                    infos = list.getTModelInfos();
                }
                if (infos != null) {
                    tmarr = infos.getTModelInfoArray();
                }
                for (int i = 0; tmarr != null && i < tmarr.length; ++i) {
                    TModelInfo info = tmarr[i];
                    col.add(ScoutUddiJaxrHelper.getConcept(info, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager()));
                }
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return new BulkResponseImpl(col);
    }

    @Override
    public BulkResponse findRegistryPackages(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public BulkResponse findServiceBindings(Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistry iRegistry = this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        try {
            BindingDetail l = iRegistry.findBinding(serviceKey.getId(), ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), null, juddiFindQualifiers, this.registryService.getMaxRows());
            if (l != null) {
                BindingTemplate[] bindarr = l.getBindingTemplateArray();
                LinkedHashSet<ServiceBinding> col = new LinkedHashSet<ServiceBinding>();
                for (int i = 0; bindarr != null && i < bindarr.length; ++i) {
                    BindingTemplate si = bindarr[i];
                    ServiceBinding sb = ScoutUddiJaxrHelper.getServiceBinding(si, this.registryService.getBusinessLifeCycleManager());
                    col.add(sb);
                    Service s = (Service)this.getRegistryObject(serviceKey.getId(), "Service");
                    ((ServiceBindingImpl)sb).setService(s);
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    @Override
    public BulkResponse findServices(Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specificationa) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistry iRegistry = this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        Name[] juddiNames = BusinessQueryManagerImpl.mapNamePatterns(namePatterns);
        try {
            ServiceList l;
            String id = null;
            if (orgKey != null) {
                id = orgKey.getId();
            }
            if ((l = iRegistry.findService(id, juddiNames, ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), null, juddiFindQualifiers, this.registryService.getMaxRows())) != null) {
                ServiceInfos serviceInfos = l.getServiceInfos();
                ServiceInfo[] a = serviceInfos != null ? serviceInfos.getServiceInfoArray() : null;
                LinkedHashSet<Service> col = new LinkedHashSet<Service>();
                for (int i = 0; a != null && i < a.length; ++i) {
                    ServiceInfo si = a[i];
                    col.add(ScoutUddiJaxrHelper.getService(si, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager()));
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    @Override
    public RegistryObject getRegistryObject(String id) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public RegistryObject getRegistryObject(String id, String objectType) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        BusinessLifeCycleManager lcm = this.registryService.getBusinessLifeCycleManager();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(id);
                Concept c = ScoutUddiJaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
                ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(lcm);
                scheme.setName(c.getName());
                scheme.setDescription(c.getDescription());
                scheme.setKey(c.getKey());
                return scheme;
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            try {
                BusinessDetail orgdetail = registry.getBusinessDetail(id);
                return ScoutUddiJaxrHelper.getOrganization(orgdetail, (LifeCycleManager)lcm);
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(id);
                return ScoutUddiJaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Service".equalsIgnoreCase(objectType)) {
            try {
                BusinessService[] a;
                ServiceDetail sd = registry.getServiceDetail(id);
                if (sd != null && (a = sd.getBusinessServiceArray()) != null && a.length != 0) {
                    Service service = this.getServiceFromBusinessService(a[0], lcm);
                    return service;
                }
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Service getServiceFromBusinessService(BusinessService bs, LifeCycleManager lcm) throws JAXRException {
        Service service = ScoutUddiJaxrHelper.getService(bs, lcm);
        String busKey = bs.getBusinessKey();
        if (busKey != null) {
            Organization o = (Organization)this.getRegistryObject(busKey, "Organization");
            service.setProvidingOrganization(o);
        }
        return service;
    }

    @Override
    public BulkResponse getRegistryObjects() throws JAXRException {
        String[] types = new String[]{"Organization", "Service"};
        LinkedHashSet c = new LinkedHashSet();
        for (int i = 0; i < types.length; ++i) {
            try {
                BulkResponse bk = this.getRegistryObjects(types[i]);
                if (bk.getCollection() == null) continue;
                c.addAll(bk.getCollection());
                continue;
            }
            catch (JAXRException e) {
                // empty catch block
            }
        }
        return new BulkResponseImpl(c);
    }

    public BulkResponse getRegistryObjects(Collection<Key> objectKeys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BulkResponse getRegistryObjects(Collection<Key> objectKeys, String objectType) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        String[] keys = new String[objectKeys.size()];
        int currLoc = 0;
        for (Key key : objectKeys) {
            keys[currLoc] = key.getId();
            ++currLoc;
        }
        LinkedHashSet<RegistryObject> col = new LinkedHashSet<RegistryObject>();
        BusinessLifeCycleManagerImpl lcm = this.registryService.getLifeCycleManagerImpl();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(keys);
                TModel[] tmarray = tmodeldetail.getTModelArray();
                for (int i = 0; tmarray != null && i < tmarray.length; ++i) {
                    col.add(ScoutUddiJaxrHelper.getConcept(tmarray[i], (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            try {
                BusinessDetail orgdetail = registry.getBusinessDetail(keys);
                BusinessEntity[] bizarr = orgdetail.getBusinessEntityArray();
                for (int i = 0; bizarr != null && i < bizarr.length; ++i) {
                    col.add(ScoutUddiJaxrHelper.getOrganization(bizarr[i], (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(keys);
                TModel[] tmarr = tmodeldetail.getTModelArray();
                for (int i = 0; tmarr != null && i < tmarr.length; ++i) {
                    col.add(ScoutUddiJaxrHelper.getConcept(tmarr[i], (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if (!"Service".equalsIgnoreCase(objectType)) throw new JAXRException("Unsupported type " + objectType + " for getRegistryObjects() in Apache Scout");
        try {
            ServiceDetail serviceDetail = registry.getServiceDetail(keys);
            if (serviceDetail == null) return new BulkResponseImpl(col);
            BusinessService[] a = serviceDetail.getBusinessServiceArray();
            for (int i = 0; a != null && i < a.length; ++i) {
                Service service = this.getServiceFromBusinessService(a[i], lcm);
                col.add(service);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException(e);
        }
    }

    @Override
    public BulkResponse getRegistryObjects(String id) throws JAXRException {
        if ("Organization".equalsIgnoreCase(id)) {
            ArrayList<String> a = new ArrayList<String>();
            a.add("%");
            BulkResponse br = this.findOrganizations(null, a, null, null, null, null);
            return br;
        }
        if ("Service".equalsIgnoreCase(id)) {
            ArrayList<String> a = new ArrayList<String>();
            a.add("%");
            BulkResponse br = this.findServices(null, null, a, null, null);
            return br;
        }
        throw new JAXRException("Unsupported type for getRegistryObjects() :" + id);
    }

    static FindQualifiers mapFindQualifiers(Collection jaxrQualifiers) throws UnsupportedCapabilityException {
        if (jaxrQualifiers == null) {
            return null;
        }
        FindQualifiers result = FindQualifiers.Factory.newInstance();
        for (String jaxrQualifier : jaxrQualifiers) {
            String juddiQualifier = jaxrQualifier;
            if (juddiQualifier == null) {
                throw new UnsupportedCapabilityException("jUDDI does not support FindQualifer: " + jaxrQualifier);
            }
            result.addFindQualifier(juddiQualifier);
        }
        return result;
    }

    static Name[] mapNamePatterns(Collection namePatterns) throws JAXRException {
        if (namePatterns == null) {
            return null;
        }
        Name[] result = new Name[namePatterns.size()];
        int currLoc = 0;
        for (Object obj : namePatterns) {
            Name n = Name.Factory.newInstance();
            if (obj instanceof String) {
                n.setStringValue((String)obj);
            } else if (obj instanceof LocalizedString) {
                LocalizedString ls = (LocalizedString)obj;
                n.setStringValue(ls.getValue());
                n.setLang(ls.getLocale().getLanguage());
            }
            result[currLoc] = n;
            ++currLoc;
        }
        return result;
    }

    private AuthToken getAuthToken(ConnectionImpl connection, IRegistry ireg) throws JAXRException {
        Set creds = connection.getCredentials();
        Iterator it = creds.iterator();
        String username = "";
        String pwd = "";
        while (it.hasNext()) {
            PasswordAuthentication pass = (PasswordAuthentication)it.next();
            username = pass.getUserName();
            pwd = new String(pass.getPassword());
        }
        AuthToken token = null;
        try {
            token = ireg.getAuthToken(username, pwd);
        }
        catch (Exception e) {
            throw new JAXRException(e);
        }
        return token;
    }
}

