/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver = RetrievalMethodResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.RetrievalMethodResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver).getName());
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod");
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            Attr attr = retrievalMethod.getURIAttr();
            String string2 = retrievalMethod.getType();
            Transforms transforms = retrievalMethod.getTransforms();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
            if (resourceResolver != null) {
                XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                if (log.isDebugEnabled()) {
                    log.debug("Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                }
                if (transforms != null) {
                    log.debug("We have Transforms");
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                if (log.isDebugEnabled()) {
                    log.debug("After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                    log.debug("Resolved to resource " + xMLSignatureInput.getSourceURI());
                }
                byte[] byArray = xMLSignatureInput.getBytes();
                if (string2 != null && string2.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    if (x509Certificate != null) {
                        return x509Certificate.getPublicKey();
                    }
                } else {
                    KeyResolver keyResolver;
                    if (log.isDebugEnabled()) {
                        log.debug("we have to parse " + byArray.length + " bytes");
                    }
                    Element element2 = this.getDocFromBytes(byArray);
                    if (log.isDebugEnabled()) {
                        log.debug("Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
                    }
                    if (element2 != null && (keyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver)) != null) {
                        return keyResolver.resolvePublicKey(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver);
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.debug("CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.debug("IOException", iOException);
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        try {
            ResourceResolver resourceResolver;
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            Attr attr = retrievalMethod.getURIAttr();
            Transforms transforms = retrievalMethod.getTransforms();
            if (log.isDebugEnabled()) {
                log.debug("Asked to resolve URI " + attr);
            }
            if ((resourceResolver = ResourceResolver.getInstance(attr, string)) != null) {
                XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                if (log.isDebugEnabled()) {
                    log.debug("Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                }
                if (transforms != null) {
                    log.debug("We have Transforms");
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                if (log.isDebugEnabled()) {
                    log.debug("After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                    log.debug("Resolved to resource " + xMLSignatureInput.getSourceURI());
                }
                byte[] byArray = xMLSignatureInput.getBytes();
                if (retrievalMethod.getType() != null && retrievalMethod.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    if (x509Certificate != null) {
                        return x509Certificate;
                    }
                } else {
                    KeyResolver keyResolver;
                    if (log.isDebugEnabled()) {
                        log.debug("we have to parse " + byArray.length + " bytes");
                    }
                    Element element2 = this.getDocFromBytes(byArray);
                    if (log.isDebugEnabled()) {
                        log.debug("Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
                    }
                    if (element2 != null && (keyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver)) != null) {
                        return keyResolver.resolveX509Certificate(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver);
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.debug("CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.debug("IOException", iOException);
        }
        return null;
    }

    Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static Element getFirstElementChild(Element element) {
        Node node;
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

